/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.StreamCompressionDecorator;

public class CompressibleFSDataInputStream
extends FSDataInputStream {
    private final FSDataInputStream delegate;
    private final InputStream compressingDelegate;

    public CompressibleFSDataInputStream(FSDataInputStream delegate, StreamCompressionDecorator compressionDecorator) throws IOException {
        this.delegate = delegate;
        this.compressingDelegate = compressionDecorator.decorateWithCompression(delegate);
    }

    @Override
    public void seek(long desired) throws IOException {
        int available = this.compressingDelegate.available();
        if (available > 0 && (long)available != this.compressingDelegate.skip(available)) {
            throw new IOException("Unable to skip buffered data.");
        }
        this.delegate.seek(desired);
    }

    @Override
    public long getPos() throws IOException {
        return this.delegate.getPos();
    }

    @Override
    public int read() throws IOException {
        return this.compressingDelegate.read();
    }

    @Override
    public void close() throws IOException {
        this.compressingDelegate.close();
    }
}

