/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersion;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class ExecutionVertexVersioner {
    private final Map<ExecutionVertexID, Long> executionVertexToVersion = new HashMap<ExecutionVertexID, Long>();

    public ExecutionVertexVersion recordModification(ExecutionVertexID executionVertexId) {
        Long newVersion = this.executionVertexToVersion.merge(executionVertexId, 1L, Long::sum);
        return new ExecutionVertexVersion(executionVertexId, newVersion);
    }

    public Map<ExecutionVertexID, ExecutionVertexVersion> recordVertexModifications(Collection<ExecutionVertexID> vertices) {
        return vertices.stream().map(this::recordModification).collect(Collectors.toMap(ExecutionVertexVersion::getExecutionVertexId, Function.identity()));
    }

    public boolean isModified(ExecutionVertexVersion executionVertexVersion) {
        Long currentVersion = this.getCurrentVersion(executionVertexVersion.getExecutionVertexId());
        return currentVersion.longValue() != executionVertexVersion.getVersion();
    }

    private Long getCurrentVersion(ExecutionVertexID executionVertexId) {
        Long currentVersion = this.executionVertexToVersion.get(executionVertexId);
        Preconditions.checkState(currentVersion != null, "Execution vertex %s does not have a recorded version", executionVertexId);
        return currentVersion;
    }

    public Set<ExecutionVertexID> getUnmodifiedExecutionVertices(Set<ExecutionVertexVersion> executionVertexVersions) {
        return executionVertexVersions.stream().filter(executionVertexVersion -> !this.isModified((ExecutionVertexVersion)executionVertexVersion)).map(ExecutionVertexVersion::getExecutionVertexId).collect(Collectors.toSet());
    }

    public Map<ExecutionVertexID, ExecutionVertexVersion> getExecutionVertexVersions(Collection<ExecutionVertexID> executionVertexIds) {
        return executionVertexIds.stream().map(id -> new ExecutionVertexVersion((ExecutionVertexID)id, this.getCurrentVersion((ExecutionVertexID)id))).collect(Collectors.toMap(ExecutionVertexVersion::getExecutionVertexId, Function.identity()));
    }

    public ExecutionVertexVersion getExecutionVertexVersion(ExecutionVertexID executionVertexId) {
        long currentVersion = this.getCurrentVersion(executionVertexId);
        return new ExecutionVertexVersion(executionVertexId, currentVersion);
    }
}

