/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.docs.FlinkJsonSchema;
import org.apache.flink.runtime.jobgraph.JobResourceRequirements;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexResourceRequirements;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDKeyDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDKeySerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@FlinkJsonSchema.AdditionalFields(type=JobVertexResourceRequirements.class)
public class JobResourceRequirementsBody
implements RequestBody,
ResponseBody {
    @JsonAnySetter
    @JsonAnyGetter
    @JsonSerialize(keyUsing=JobVertexIDKeySerializer.class)
    @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class)
    private final Map<JobVertexID, JobVertexResourceRequirements> jobVertexResourceRequirements;

    public JobResourceRequirementsBody() {
        this(null);
    }

    public JobResourceRequirementsBody(@Nullable JobResourceRequirements jobResourceRequirements) {
        this.jobVertexResourceRequirements = jobResourceRequirements != null ? jobResourceRequirements.getJobVertexParallelisms() : new HashMap<JobVertexID, JobVertexResourceRequirements>();
    }

    @JsonIgnore
    public Optional<JobResourceRequirements> asJobResourceRequirements() {
        if (this.jobVertexResourceRequirements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new JobResourceRequirements(this.jobVertexResourceRequirements));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobResourceRequirementsBody that = (JobResourceRequirementsBody)o;
        return Objects.equals(this.jobVertexResourceRequirements, that.jobVertexResourceRequirements);
    }

    public int hashCode() {
        return Objects.hash(this.jobVertexResourceRequirements);
    }
}

