/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.persistence;

import javax.annotation.Nonnull;
import org.apache.flink.runtime.persistence.ResourceVersion;
import org.apache.flink.util.Preconditions;

public class IntegerResourceVersion
implements ResourceVersion<IntegerResourceVersion> {
    private static final long serialVersionUID = 1L;
    private static final IntegerResourceVersion NOT_EXISTING = new IntegerResourceVersion(-1);
    private final int value;

    private IntegerResourceVersion(int value) {
        this.value = value;
    }

    @Override
    public int compareTo(@Nonnull IntegerResourceVersion other) {
        return Integer.compare(this.value, other.getValue());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == IntegerResourceVersion.class) {
            IntegerResourceVersion that = (IntegerResourceVersion)obj;
            return this.value == that.getValue();
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    @Override
    public boolean isExisting() {
        return this != NOT_EXISTING;
    }

    public String toString() {
        return "IntegerResourceVersion{value='" + this.value + '\'' + '}';
    }

    public int getValue() {
        return this.value;
    }

    public static IntegerResourceVersion notExisting() {
        return NOT_EXISTING;
    }

    public static IntegerResourceVersion valueOf(int value) {
        Preconditions.checkArgument(value >= 0);
        return new IntegerResourceVersion(value);
    }
}

