/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.jobgraph.SavepointConfigOptions;
import org.apache.flink.util.Preconditions;

public class SavepointRestoreSettings
implements Serializable {
    private static final long serialVersionUID = 87377506900849777L;
    private static final SavepointRestoreSettings NONE = new SavepointRestoreSettings(null, false, RestoreMode.NO_CLAIM);
    private final String restorePath;
    private final boolean allowNonRestoredState;
    @Nonnull
    private final RestoreMode restoreMode;

    private SavepointRestoreSettings(String restorePath, boolean allowNonRestoredState, @Nonnull RestoreMode restoreMode) {
        this.restorePath = restorePath;
        this.allowNonRestoredState = allowNonRestoredState;
        this.restoreMode = restoreMode;
    }

    public boolean restoreSavepoint() {
        return this.restorePath != null;
    }

    public String getRestorePath() {
        return this.restorePath;
    }

    public boolean allowNonRestoredState() {
        return this.allowNonRestoredState;
    }

    @Nonnull
    public RestoreMode getRestoreMode() {
        return this.restoreMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavepointRestoreSettings that = (SavepointRestoreSettings)o;
        return this.allowNonRestoredState == that.allowNonRestoredState && Objects.equals(this.restorePath, that.restorePath) && Objects.equals(this.restoreMode, that.restoreMode);
    }

    public int hashCode() {
        int result = this.restorePath != null ? this.restorePath.hashCode() : 0;
        result = 31 * result + this.restoreMode.hashCode();
        result = 31 * result + (this.allowNonRestoredState ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.restoreSavepoint()) {
            return "SavepointRestoreSettings.forPath(restorePath='" + this.restorePath + '\'' + ", allowNonRestoredState=" + this.allowNonRestoredState + ", restoreMode=" + this.restoreMode + ')';
        }
        return "SavepointRestoreSettings.none()";
    }

    public static SavepointRestoreSettings none() {
        return NONE;
    }

    public static SavepointRestoreSettings forPath(String savepointPath) {
        return SavepointRestoreSettings.forPath(savepointPath, SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE.defaultValue());
    }

    public static SavepointRestoreSettings forPath(String savepointPath, boolean allowNonRestoredState) {
        Preconditions.checkNotNull(savepointPath, "Savepoint restore path.");
        return new SavepointRestoreSettings(savepointPath, allowNonRestoredState, SavepointConfigOptions.RESTORE_MODE.defaultValue());
    }

    public static SavepointRestoreSettings forPath(String savepointPath, boolean allowNonRestoredState, @Nonnull RestoreMode restoreMode) {
        Preconditions.checkNotNull(savepointPath, "Savepoint restore path.");
        return new SavepointRestoreSettings(savepointPath, allowNonRestoredState, restoreMode);
    }

    public static void toConfiguration(SavepointRestoreSettings savepointRestoreSettings, Configuration configuration) {
        configuration.set((ConfigOption)SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE, (Object)savepointRestoreSettings.allowNonRestoredState());
        configuration.set((ConfigOption)SavepointConfigOptions.RESTORE_MODE, savepointRestoreSettings.getRestoreMode());
        String savepointPath = savepointRestoreSettings.getRestorePath();
        if (savepointPath != null) {
            configuration.set((ConfigOption)SavepointConfigOptions.SAVEPOINT_PATH, savepointPath);
        }
    }

    public static SavepointRestoreSettings fromConfiguration(ReadableConfig configuration) {
        String savepointPath = configuration.get(SavepointConfigOptions.SAVEPOINT_PATH);
        boolean allowNonRestored = configuration.get(SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE);
        RestoreMode restoreMode = configuration.get(SavepointConfigOptions.RESTORE_MODE);
        return savepointPath == null ? SavepointRestoreSettings.none() : SavepointRestoreSettings.forPath(savepointPath, allowNonRestored, restoreMode);
    }
}

