/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.io.network.metrics.ResultPartitionBytesCounter;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class IOMetrics
implements Serializable {
    private static final long serialVersionUID = -7208093607556457183L;
    protected long numRecordsIn;
    protected long numRecordsOut;
    protected long numBytesIn;
    protected long numBytesOut;
    protected long accumulateBackPressuredTime;
    protected double accumulateBusyTime;
    protected long accumulateIdleTime;
    @Nullable
    protected Map<IntermediateResultPartitionID, ResultPartitionBytes> resultPartitionBytes;

    public IOMetrics(Meter recordsIn, Meter recordsOut, Meter bytesIn, Meter bytesOut, Gauge<Long> accumulatedBackPressuredTime, Gauge<Long> accumulatedIdleTime, Gauge<Double> accumulatedBusyTime, Map<IntermediateResultPartitionID, ResultPartitionBytesCounter> resultPartitionBytesCounters) {
        this.numRecordsIn = recordsIn.getCount();
        this.numRecordsOut = recordsOut.getCount();
        this.numBytesIn = bytesIn.getCount();
        this.numBytesOut = bytesOut.getCount();
        this.accumulateBackPressuredTime = (Long)accumulatedBackPressuredTime.getValue();
        this.accumulateBusyTime = (Double)accumulatedBusyTime.getValue();
        this.accumulateIdleTime = (Long)accumulatedIdleTime.getValue();
        this.resultPartitionBytes = resultPartitionBytesCounters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ResultPartitionBytesCounter)entry.getValue()).createSnapshot()));
    }

    public IOMetrics(long numBytesIn, long numBytesOut, long numRecordsIn, long numRecordsOut, long accumulateIdleTime, double accumulateBusyTime, long accumulateBackPressuredTime) {
        this(numBytesIn, numBytesOut, numRecordsIn, numRecordsOut, accumulateIdleTime, accumulateBusyTime, accumulateBackPressuredTime, null);
    }

    @VisibleForTesting
    public IOMetrics(long numBytesIn, long numBytesOut, long numRecordsIn, long numRecordsOut, long accumulateIdleTime, double accumulateBusyTime, long accumulateBackPressuredTime, @Nullable Map<IntermediateResultPartitionID, ResultPartitionBytes> resultPartitionBytes) {
        this.numBytesIn = numBytesIn;
        this.numBytesOut = numBytesOut;
        this.numRecordsIn = numRecordsIn;
        this.numRecordsOut = numRecordsOut;
        this.accumulateIdleTime = accumulateIdleTime;
        this.accumulateBusyTime = accumulateBusyTime;
        this.accumulateBackPressuredTime = accumulateBackPressuredTime;
        this.resultPartitionBytes = resultPartitionBytes;
    }

    public long getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public long getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public long getNumBytesIn() {
        return this.numBytesIn;
    }

    public long getNumBytesOut() {
        return this.numBytesOut;
    }

    public double getAccumulateBusyTime() {
        return this.accumulateBusyTime;
    }

    public long getAccumulateBackPressuredTime() {
        return this.accumulateBackPressuredTime;
    }

    public long getAccumulateIdleTime() {
        return this.accumulateIdleTime;
    }

    public Map<IntermediateResultPartitionID, ResultPartitionBytes> getResultPartitionBytes() {
        return Collections.unmodifiableMap(Preconditions.checkNotNull(this.resultPartitionBytes));
    }
}

