/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalFile {
    private static final Logger LOG = LoggerFactory.getLogger(PhysicalFile.class);
    @Nullable
    private FSDataOutputStream outputStream;
    private final AtomicInteger logicalFileRefCount;
    private final AtomicLong size;
    @Nullable
    private final PhysicalFileDeleter deleter;
    private final Path filePath;
    private final CheckpointedStateScope scope;
    private boolean closed;
    private boolean deleted = false;

    public PhysicalFile(@Nullable FSDataOutputStream outputStream, Path filePath, @Nullable PhysicalFileDeleter deleter, CheckpointedStateScope scope) {
        this.filePath = filePath;
        this.outputStream = outputStream;
        this.closed = outputStream == null;
        this.deleter = deleter;
        this.scope = scope;
        this.size = new AtomicLong(0L);
        this.logicalFileRefCount = new AtomicInteger(0);
    }

    @Nullable
    public FSDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    void incRefCount() {
        int newValue = this.logicalFileRefCount.incrementAndGet();
        LOG.trace("Increase the reference count of physical file: {} by 1. New value is: {}.", (Object)this.filePath, (Object)newValue);
    }

    void decRefCount() throws IOException {
        Preconditions.checkArgument(this.logicalFileRefCount.get() > 0);
        int newValue = this.logicalFileRefCount.decrementAndGet();
        LOG.trace("Decrease the reference count of physical file: {} by 1. New value is: {}. ", (Object)this.filePath, (Object)newValue);
        this.deleteIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIfNecessary() throws IOException {
        PhysicalFile physicalFile = this;
        synchronized (physicalFile) {
            if (!this.isOpen() && !this.deleted && this.logicalFileRefCount.get() <= 0) {
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Fail to close output stream when deleting file: {}", (Object)this.filePath);
                    }
                }
                if (this.deleter != null) {
                    this.deleter.perform(this.filePath);
                }
                this.deleted = true;
            }
        }
    }

    void incSize(long delta) {
        this.size.addAndGet(delta);
    }

    long getSize() {
        return this.size.get();
    }

    @VisibleForTesting
    int getRefCount() {
        return this.logicalFileRefCount.get();
    }

    public void close() throws IOException {
        this.innerClose();
        this.deleteIfNecessary();
    }

    private void innerClose() throws IOException {
        this.closed = true;
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    public boolean isOpen() {
        return !this.closed && this.outputStream != null;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public CheckpointedStateScope getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalFile that = (PhysicalFile)o;
        return this.filePath.equals(that.filePath);
    }

    public String toString() {
        return String.format("Physical File: [%s], closed: %s, logicalFileRefCount: %d", this.filePath, this.closed, this.logicalFileRefCount.get());
    }

    @FunctionalInterface
    public static interface PhysicalFileDeleter {
        public void perform(Path var1) throws IOException;
    }
}

