/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.InitializationStatus;
import org.apache.flink.runtime.checkpoint.JobInitializationMetrics;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetrics;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobInitializationMetricsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JobInitializationMetricsBuilder.class);
    private final List<SubTaskInitializationMetrics> reportedMetrics = new ArrayList<SubTaskInitializationMetrics>();
    private final int totalNumberOfSubTasks;
    private final long startTs;
    private Optional<Long> stateSize = Optional.empty();
    private Optional<Long> checkpointId = Optional.empty();
    private Optional<CheckpointProperties> checkpointProperties = Optional.empty();
    private Optional<String> externalPath = Optional.empty();

    JobInitializationMetricsBuilder(int totalNumberOfSubTasks, long startTs) {
        Preconditions.checkArgument(totalNumberOfSubTasks > 0);
        this.totalNumberOfSubTasks = totalNumberOfSubTasks;
        this.startTs = startTs;
    }

    public boolean isComplete() {
        return this.reportedMetrics.size() == this.totalNumberOfSubTasks;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public Optional<RestoredCheckpointStats> buildRestoredCheckpointStats() {
        if (this.checkpointId.isPresent() && this.checkpointProperties.isPresent() && this.stateSize.isPresent()) {
            return Optional.of(new RestoredCheckpointStats(this.checkpointId.get(), this.checkpointProperties.get(), this.startTs, this.externalPath.orElse(null), this.stateSize.get()));
        }
        return Optional.empty();
    }

    public JobInitializationMetrics build() {
        Preconditions.checkState(this.isComplete());
        long initializationEndTimestamp = 0L;
        HashMap<String, JobInitializationMetrics.SumMaxDuration> duationMetrics = new HashMap<String, JobInitializationMetrics.SumMaxDuration>();
        InitializationStatus status = InitializationStatus.COMPLETED;
        block4: for (SubTaskInitializationMetrics reportedMetric : this.reportedMetrics) {
            initializationEndTimestamp = Math.max(reportedMetric.getEndTs(), initializationEndTimestamp);
            JobInitializationMetricsBuilder.aggregateMetrics(duationMetrics, reportedMetric.getDurationMetrics());
            switch (reportedMetric.getStatus()) {
                case COMPLETED: {
                    continue block4;
                }
                case FAILED: {
                    status = InitializationStatus.FAILED;
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown reported " + InitializationStatus.class.getSimpleName() + " = [" + (Object)((Object)reportedMetric.getStatus()) + "]");
        }
        return new JobInitializationMetrics(this.checkpointId.orElse(-1L), this.stateSize.orElse(-1L), status, this.startTs, initializationEndTimestamp, duationMetrics);
    }

    private static void aggregateMetrics(Map<String, JobInitializationMetrics.SumMaxDuration> target, Map<String, Long> sourceDurationMetrics) {
        for (Map.Entry<String, Long> durationMetric : sourceDurationMetrics.entrySet()) {
            String name = durationMetric.getKey();
            long value = durationMetric.getValue();
            JobInitializationMetrics.SumMaxDuration targetDuration = target.computeIfAbsent(name, k -> new JobInitializationMetrics.SumMaxDuration((String)k));
            targetDuration.addDuration(value);
        }
    }

    public void reportInitializationMetrics(SubTaskInitializationMetrics initializationMetrics) {
        LOG.debug("Reported SubTaskInitializationMetrics={}", (Object)initializationMetrics);
        if (this.isComplete()) {
            LOG.warn("Reported more SubTaskInitializationMetrics than expected!");
            return;
        }
        this.reportedMetrics.add(initializationMetrics);
    }

    public JobInitializationMetricsBuilder setRestoredCheckpointStats(long checkpointId, long stateSize, CheckpointProperties checkpointProperties, String externalPath) {
        this.checkpointId = Optional.of(checkpointId);
        this.stateSize = Optional.of(stateSize);
        this.checkpointProperties = Optional.ofNullable(checkpointProperties);
        this.externalPath = Optional.ofNullable(externalPath);
        return this;
    }
}

