/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.blob.AbstractBlobCache;
import org.apache.flink.runtime.blob.BlobCacheSizeTracker;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.JobPermanentBlobService;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermanentBlobCache
extends AbstractBlobCache
implements JobPermanentBlobService {
    private static final int DEFAULT_SIZE_LIMIT_MB = 100;
    private final Map<JobID, RefCount> jobRefCounters = new HashMap<JobID, RefCount>();
    private final long cleanupInterval;
    private final Timer cleanupTimer = new Timer(true);
    private final BlobCacheSizeTracker blobCacheSizeTracker;

    @VisibleForTesting
    public PermanentBlobCache(Configuration blobClientConfig, File storageDir, BlobView blobView, @Nullable InetSocketAddress serverAddress) throws IOException {
        this(blobClientConfig, Reference.owned(storageDir), blobView, serverAddress);
    }

    @VisibleForTesting
    public PermanentBlobCache(Configuration blobClientConfig, File storageDir, BlobView blobView, @Nullable InetSocketAddress serverAddress, BlobCacheSizeTracker blobCacheSizeTracker) throws IOException {
        this(blobClientConfig, Reference.owned(storageDir), blobView, serverAddress, blobCacheSizeTracker);
    }

    public PermanentBlobCache(Configuration blobClientConfig, Reference<File> storageDir, BlobView blobView, @Nullable InetSocketAddress serverAddress) throws IOException {
        this(blobClientConfig, storageDir, blobView, serverAddress, new BlobCacheSizeTracker(MemorySize.ofMebiBytes(100L).getBytes()));
    }

    @VisibleForTesting
    public PermanentBlobCache(Configuration blobClientConfig, Reference<File> storageDir, BlobView blobView, @Nullable InetSocketAddress serverAddress, BlobCacheSizeTracker blobCacheSizeTracker) throws IOException {
        super(blobClientConfig, storageDir, blobView, LoggerFactory.getLogger(PermanentBlobCache.class), serverAddress);
        this.cleanupInterval = blobClientConfig.get(BlobServerOptions.CLEANUP_INTERVAL) * 1000L;
        this.cleanupTimer.schedule((TimerTask)new PermanentBlobCleanupTask(), this.cleanupInterval, this.cleanupInterval);
        this.blobCacheSizeTracker = blobCacheSizeTracker;
        this.registerDetectedJobs();
    }

    private void registerDetectedJobs() throws IOException {
        if (((File)this.storageDir.deref()).exists()) {
            Set<JobID> jobIds = BlobUtils.listExistingJobs(((File)this.storageDir.deref()).toPath());
            long expiryTimeout = System.currentTimeMillis() + this.cleanupInterval;
            for (JobID jobId : jobIds) {
                this.registerJobWithExpiry(jobId, expiryTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerJobWithExpiry(JobID jobId, long expiryTimeout) {
        Preconditions.checkNotNull(jobId);
        Map<JobID, RefCount> map = this.jobRefCounters;
        synchronized (map) {
            RefCount refCount = this.jobRefCounters.computeIfAbsent(jobId, ignored -> new RefCount());
            refCount.keepUntil = expiryTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerJob(JobID jobId) {
        Preconditions.checkNotNull(jobId);
        Map<JobID, RefCount> map = this.jobRefCounters;
        synchronized (map) {
            RefCount ref = this.jobRefCounters.get(jobId);
            if (ref == null) {
                ref = new RefCount();
                this.jobRefCounters.put(jobId, ref);
            } else {
                ref.keepUntil = -1L;
            }
            ++ref.references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseJob(JobID jobId) {
        Preconditions.checkNotNull(jobId);
        Map<JobID, RefCount> map = this.jobRefCounters;
        synchronized (map) {
            RefCount ref = this.jobRefCounters.get(jobId);
            if (ref == null || ref.references == 0) {
                this.log.warn("improper use of releaseJob() without a matching number of registerJob() calls for jobId " + jobId);
                return;
            }
            --ref.references;
            if (ref.references == 0) {
                ref.keepUntil = System.currentTimeMillis() + this.cleanupInterval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfReferenceHolders(JobID jobId) {
        Preconditions.checkNotNull(jobId);
        Map<JobID, RefCount> map = this.jobRefCounters;
        synchronized (map) {
            RefCount ref = this.jobRefCounters.get(jobId);
            if (ref == null) {
                return 0;
            }
            return ref.references;
        }
    }

    @Override
    public File getFile(JobID jobId, PermanentBlobKey key) throws IOException {
        Preconditions.checkNotNull(jobId);
        return this.getFileInternal(jobId, key);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] readFile(JobID jobId, PermanentBlobKey blobKey) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkLimitAndMoveFile(File incomingFile, JobID jobId, BlobKey blobKey, File localFile, Logger log, @Nullable BlobStore blobStore) throws IOException {
        long sizeOfIncomingFile = incomingFile.length();
        List<Tuple2<JobID, BlobKey>> blobsToDelete = this.blobCacheSizeTracker.checkLimit(sizeOfIncomingFile);
        for (Tuple2<JobID, BlobKey> key : blobsToDelete) {
            if (!this.deleteFile((JobID)key.f0, (BlobKey)key.f1)) continue;
            this.blobCacheSizeTracker.untrack(key);
        }
        BlobUtils.moveTempFileToStore(incomingFile, jobId, blobKey, localFile, log, blobStore);
        this.blobCacheSizeTracker.track(jobId, blobKey, localFile.length());
    }

    private boolean deleteFile(JobID jobId, BlobKey blobKey) {
        File localFile = new File(BlobUtils.getStorageLocationPath(((File)this.storageDir.deref()).getAbsolutePath(), jobId, blobKey));
        if (!localFile.delete() && localFile.exists()) {
            this.log.warn("Failed to delete locally cached BLOB {} at {}", (Object)blobKey, (Object)localFile.getAbsolutePath());
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public File getStorageLocation(JobID jobId, BlobKey key) throws IOException {
        Preconditions.checkNotNull(jobId);
        return BlobUtils.getStorageLocation((File)this.storageDir.deref(), jobId, key);
    }

    @VisibleForTesting
    Map<JobID, RefCount> getJobRefCounters() {
        return this.jobRefCounters;
    }

    @Override
    protected void cancelCleanupTask() {
        this.cleanupTimer.cancel();
    }

    class PermanentBlobCleanupTask
    extends TimerTask {
        PermanentBlobCleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = PermanentBlobCache.this.jobRefCounters;
            synchronized (map) {
                Iterator entryIter = PermanentBlobCache.this.jobRefCounters.entrySet().iterator();
                long currentTimeMillis = System.currentTimeMillis();
                while (entryIter.hasNext()) {
                    Map.Entry entry = entryIter.next();
                    RefCount ref = (RefCount)entry.getValue();
                    if (ref.references > 0 || ref.keepUntil <= 0L || currentTimeMillis < ref.keepUntil) continue;
                    JobID jobId = (JobID)entry.getKey();
                    File localFile = new File(BlobUtils.getStorageLocationPath(((File)PermanentBlobCache.this.storageDir.deref()).getAbsolutePath(), jobId));
                    PermanentBlobCache.this.readWriteLock.writeLock().lock();
                    boolean success = false;
                    try {
                        PermanentBlobCache.this.blobCacheSizeTracker.untrackAll(jobId);
                        FileUtils.deleteDirectory(localFile);
                        success = true;
                    }
                    catch (Throwable t) {
                        PermanentBlobCache.this.log.warn("Failed to locally delete job directory " + localFile.getAbsolutePath(), t);
                    }
                    finally {
                        PermanentBlobCache.this.readWriteLock.writeLock().unlock();
                    }
                    if (!success) continue;
                    entryIter.remove();
                }
            }
        }
    }

    @VisibleForTesting
    static class RefCount {
        public int references = 0;
        public long keepUntil = -1L;

        RefCount() {
        }
    }
}

