/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.artifact;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.flink.client.cli.ArtifactFetchOptions;
import org.apache.flink.client.program.artifact.ArtifactFetcher;
import org.apache.flink.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpArtifactFetcher
extends ArtifactFetcher {
    public static final Logger LOG = LoggerFactory.getLogger(HttpArtifactFetcher.class);

    HttpArtifactFetcher() {
    }

    @Override
    File fetch(String uri, Configuration flinkConf, File targetDir) throws IOException {
        long start = System.currentTimeMillis();
        URL url = new URL(uri);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Map<String, String> headers = flinkConf.get(ArtifactFetchOptions.HTTP_HEADERS);
        if (headers != null) {
            headers.forEach(conn::setRequestProperty);
        }
        conn.setRequestMethod("GET");
        String fileName = FilenameUtils.getName((String)url.getPath());
        File targetFile = new File(targetDir, fileName);
        try (InputStream inputStream = conn.getInputStream();){
            FileUtils.copyToFile((InputStream)inputStream, (File)targetFile);
        }
        LOG.debug("Copied file from {} to {}, cost {} ms", new Object[]{uri, targetFile, System.currentTimeMillis() - start});
        return targetFile;
    }
}

