/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.program.ProgramAbortException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.graph.StreamGraph;

@PublicEvolving
public class StreamPlanEnvironment
extends StreamExecutionEnvironment {
    private Pipeline pipeline;

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public StreamPlanEnvironment(Configuration configuration, ClassLoader userClassLoader, int parallelism) {
        super(configuration, userClassLoader);
        if (parallelism > 0) {
            this.setParallelism(parallelism);
        }
    }

    public JobClient executeAsync(StreamGraph streamGraph) {
        this.pipeline = streamGraph;
        throw new ProgramAbortException();
    }

    public void setAsContext() {
        StreamExecutionEnvironmentFactory factory = conf -> {
            this.configure(conf, this.getUserClassloader());
            return this;
        };
        StreamPlanEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    public void unsetAsContext() {
        StreamPlanEnvironment.resetContextEnvironment();
    }
}

