/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

@Internal
public class ApplicationConfiguration {
    public static final ConfigOption<List<String>> APPLICATION_ARGS = ConfigOptions.key("$internal.application.program-args").stringType().asList().noDefaultValue();
    public static final ConfigOption<String> APPLICATION_MAIN_CLASS = ConfigOptions.key("$internal.application.main").stringType().noDefaultValue();
    private final String[] programArguments;
    @Nullable
    private final String applicationClassName;

    public ApplicationConfiguration(String[] programArguments, @Nullable String applicationClassName) {
        this.programArguments = Preconditions.checkNotNull(programArguments);
        this.applicationClassName = applicationClassName;
    }

    public String[] getProgramArguments() {
        return this.programArguments;
    }

    @Nullable
    public String getApplicationClassName() {
        return this.applicationClassName;
    }

    public void applyToConfiguration(Configuration configuration) {
        Preconditions.checkNotNull(configuration);
        ConfigUtils.encodeArrayToConfig(configuration, APPLICATION_ARGS, this.programArguments, Objects::toString);
        if (this.applicationClassName != null) {
            configuration.set((ConfigOption)APPLICATION_MAIN_CLASS, this.applicationClassName);
        }
    }

    public static ApplicationConfiguration fromConfiguration(Configuration configuration) {
        Preconditions.checkNotNull(configuration);
        List<String> programArgsList = ConfigUtils.decodeListFromConfig(configuration, APPLICATION_ARGS, String::new);
        String[] programArgs = programArgsList.toArray(new String[0]);
        String applicationClassName = configuration.get(APPLICATION_MAIN_CLASS);
        return new ApplicationConfiguration(programArgs, applicationClassName);
    }
}

