/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class CommonArrayInputTypeStrategy
implements InputTypeStrategy {
    private static final Signature.Argument COMMON_ARGUMENT = Signature.Argument.ofGroup("COMMON");
    private final ArgumentCount argumentCount;

    public CommonArrayInputTypeStrategy(ArgumentCount argumentCount) {
        this.argumentCount = argumentCount;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        List<LogicalType> argumentTypes = argumentDataTypes.stream().map(DataType::getLogicalType).collect(Collectors.toList());
        if (!argumentTypes.stream().allMatch(logicalType -> logicalType.is(LogicalTypeRoot.ARRAY))) {
            return callContext.fail(throwOnFailure, "All arguments requires to be a ARRAY type", new Object[0]);
        }
        if (argumentTypes.stream().anyMatch(CommonArrayInputTypeStrategy::isLegacyType)) {
            return Optional.of(argumentDataTypes);
        }
        Optional<LogicalType> commonType = LogicalTypeMerging.findCommonType(argumentTypes);
        if (!commonType.isPresent()) {
            return callContext.fail(throwOnFailure, "Could not find a common type for arguments: %s", argumentDataTypes);
        }
        return commonType.map(type -> Collections.nCopies(argumentTypes.size(), TypeConversions.fromLogicalToDataType(type)));
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        Optional<Integer> minCount = this.argumentCount.getMinCount();
        Optional<Integer> maxCount = this.argumentCount.getMaxCount();
        int numberOfMandatoryArguments = minCount.orElse(0);
        if (maxCount.isPresent()) {
            return IntStream.range(numberOfMandatoryArguments, maxCount.get() + 1).mapToObj(count -> Signature.of(Collections.nCopies(count, COMMON_ARGUMENT))).collect(Collectors.toList());
        }
        ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>(Collections.nCopies(numberOfMandatoryArguments, COMMON_ARGUMENT));
        arguments.add(Signature.Argument.ofGroupVarying("COMMON"));
        return Collections.singletonList(Signature.of(arguments));
    }

    private static boolean isLegacyType(LogicalType type) {
        return type instanceof LegacyTypeInformationType;
    }
}

