/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.DropOperation;

public class DropTempSystemFunctionOperation
implements DropOperation {
    private final String functionName;
    private final boolean ifExists;

    public DropTempSystemFunctionOperation(String functionName, boolean ifExists) {
        this.functionName = functionName;
        this.ifExists = ifExists;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("functionName", this.functionName);
        params.put("ifExists", this.ifExists);
        return OperationUtils.formatWithChildren("DROP TEMPORARY SYSTEM FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getFunctionCatalog().dropTemporarySystemFunction(this.getFunctionName(), this.isIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

