/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.DropOperation;

public class DropCatalogFunctionOperation
implements DropOperation {
    private final ObjectIdentifier functionIdentifier;
    private final boolean ifExists;
    private final boolean isTemporary;

    public DropCatalogFunctionOperation(ObjectIdentifier functionIdentifier, boolean ifExists, boolean isTemporary) {
        this.functionIdentifier = functionIdentifier;
        this.ifExists = ifExists;
        this.isTemporary = isTemporary;
    }

    public ObjectIdentifier getFunctionIdentifier() {
        return this.functionIdentifier;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.functionIdentifier);
        params.put("ifExists", this.ifExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("DROP CATALOG FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public String getFunctionName() {
        return this.functionIdentifier.getObjectName();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            if (this.isTemporary()) {
                ctx.getFunctionCatalog().dropTempCatalogFunction(this.getFunctionIdentifier(), this.isIfExists());
            } else {
                Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.getFunctionIdentifier().getCatalogName());
                catalog.dropFunction(this.getFunctionIdentifier().toObjectPath(), this.isIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionNotExistException e) {
            throw new ValidationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

