/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;
import org.apache.flink.util.Preconditions;

public class CreateCatalogOperation
implements CreateOperation {
    private final String catalogName;
    private final Map<String, String> properties;

    public CreateCatalogOperation(String catalogName, Map<String, String> properties) {
        this.catalogName = Preconditions.checkNotNull(catalogName);
        this.properties = Collections.unmodifiableMap(Preconditions.checkNotNull(properties));
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogName", this.catalogName);
        params.put("properties", this.properties);
        return OperationUtils.formatWithChildren("CREATE CATALOG", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getCatalogManager().createCatalog(this.catalogName, CatalogDescriptor.of(this.catalogName, Configuration.fromMap(this.properties)));
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (CatalogException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

