/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterOperation;

public class AlterCatalogFunctionOperation
implements AlterOperation {
    private final ObjectIdentifier functionIdentifier;
    private final CatalogFunction catalogFunction;
    private final boolean ifExists;
    private final boolean isTemporary;

    public AlterCatalogFunctionOperation(ObjectIdentifier functionIdentifier, CatalogFunction catalogFunction, boolean ifExists, boolean isTemporary) {
        this.functionIdentifier = functionIdentifier;
        this.catalogFunction = catalogFunction;
        this.ifExists = ifExists;
        this.isTemporary = isTemporary;
    }

    public CatalogFunction getCatalogFunction() {
        return this.catalogFunction;
    }

    public ObjectIdentifier getFunctionIdentifier() {
        return this.functionIdentifier;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogFunction", this.catalogFunction.getDetailedDescription());
        params.put("identifier", this.functionIdentifier);
        params.put("ifExists", this.ifExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("ALTER CATALOG FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }

    public String getFunctionName() {
        return this.functionIdentifier.getObjectName();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            CatalogFunction function = this.getCatalogFunction();
            if (this.isTemporary()) {
                throw new ValidationException("Alter temporary catalog function is not supported");
            }
            Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.getFunctionIdentifier().getCatalogName());
            catalog.alterFunction(this.getFunctionIdentifier().toObjectPath(), function, this.isIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionNotExistException e) {
            throw new ValidationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

