/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.CheckpointBoundKeyedStateHandle;
import org.apache.flink.runtime.state.DirectoryKeyedStateHandle;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;

public class IncrementalLocalKeyedStateHandle
extends DirectoryKeyedStateHandle
implements IncrementalKeyedStateHandle {
    private static final long serialVersionUID = 1L;
    @Nonnegative
    private final long checkpointId;
    @Nonnull
    private final UUID backendIdentifier;
    @Nonnull
    private final StreamStateHandle metaDataState;
    @Nonnull
    private final List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState;

    public IncrementalLocalKeyedStateHandle(@Nonnull UUID backendIdentifier, @Nonnegative long checkpointId, @Nonnull DirectoryStateHandle directoryStateHandle, @Nonnull KeyGroupRange keyGroupRange, @Nonnull StreamStateHandle metaDataState, @Nonnull List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState) {
        super(directoryStateHandle, keyGroupRange);
        this.backendIdentifier = backendIdentifier;
        this.checkpointId = checkpointId;
        this.metaDataState = metaDataState;
        this.sharedState = new ArrayList<IncrementalKeyedStateHandle.HandleAndLocalPath>(sharedState);
    }

    @Nonnull
    public StreamStateHandle getMetaDataState() {
        return this.metaDataState;
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Override
    public CheckpointBoundKeyedStateHandle rebound(long checkpointId) {
        return new IncrementalLocalKeyedStateHandle(this.backendIdentifier, checkpointId, this.getDirectoryStateHandle(), this.getKeyGroupRange(), this.getMetaDataState(), this.getSharedStateHandles());
    }

    @Override
    @Nonnull
    public UUID getBackendIdentifier() {
        return this.backendIdentifier;
    }

    @Override
    @Nonnull
    public List<IncrementalKeyedStateHandle.HandleAndLocalPath> getSharedStateHandles() {
        return this.sharedState;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IncrementalLocalKeyedStateHandle that = (IncrementalLocalKeyedStateHandle)o;
        return this.getMetaDataState().equals(that.getMetaDataState());
    }

    @Override
    public void discardState() throws Exception {
        Exception collectedEx = null;
        try {
            super.discardState();
        }
        catch (Exception e) {
            collectedEx = e;
        }
        try {
            this.metaDataState.discardState();
        }
        catch (Exception e) {
            collectedEx = ExceptionUtils.firstOrSuppressed(e, collectedEx);
        }
        if (collectedEx != null) {
            throw collectedEx;
        }
    }

    @Override
    public long getStateSize() {
        return super.getStateSize() + this.metaDataState.getStateSize();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getMetaDataState().hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "IncrementalLocalKeyedStateHandle{metaDataState=" + this.metaDataState + "} " + super.toString();
    }
}

