/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.util.Preconditions;

public class StandaloneLeaderElection
implements LeaderElection {
    private final Object lock = new Object();
    private final UUID sessionID;
    @Nullable
    private LeaderContender leaderContender;

    public StandaloneLeaderElection(UUID sessionID) {
        this.sessionID = sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLeaderElection(LeaderContender contender) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(this.leaderContender == null, "No LeaderContender should have been registered with this LeaderElection, yet.");
            this.leaderContender = contender;
            this.leaderContender.grantLeadership(this.sessionID);
        }
    }

    @Override
    public void confirmLeadership(UUID leaderSessionID, String leaderAddress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLeadership(UUID leaderSessionId) {
        Object object = this.lock;
        synchronized (object) {
            return this.leaderContender != null && this.sessionID.equals(leaderSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.leaderContender != null) {
                this.leaderContender.revokeLeadership();
                this.leaderContender = null;
            }
        }
    }
}

