/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.util.Preconditions;

public class CheckpointCoordinatorConfiguration
implements Serializable {
    public static final long MINIMAL_CHECKPOINT_TIME = 10L;
    public static final long DISABLED_CHECKPOINT_INTERVAL = Long.MAX_VALUE;
    private static final long serialVersionUID = 2L;
    private final long checkpointInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpoints;
    private final int maxConcurrentCheckpoints;
    private final int tolerableCheckpointFailureNumber;
    private final CheckpointRetentionPolicy checkpointRetentionPolicy;
    private final boolean isExactlyOnce;
    private final boolean isUnalignedCheckpointsEnabled;
    private final long alignedCheckpointTimeout;
    private final long checkpointIdOfIgnoredInFlightData;
    private final boolean enableCheckpointsAfterTasksFinish;

    @Deprecated
    @VisibleForTesting
    public CheckpointCoordinatorConfiguration(long checkpointInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpoints, CheckpointRetentionPolicy checkpointRetentionPolicy, boolean isExactlyOnce, boolean isUnalignedCheckpoint, int tolerableCpFailureNumber, long checkpointIdOfIgnoredInFlightData) {
        this(checkpointInterval, checkpointTimeout, minPauseBetweenCheckpoints, maxConcurrentCheckpoints, checkpointRetentionPolicy, isExactlyOnce, tolerableCpFailureNumber, isUnalignedCheckpoint, 0L, checkpointIdOfIgnoredInFlightData, false);
    }

    private CheckpointCoordinatorConfiguration(long checkpointInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpoints, CheckpointRetentionPolicy checkpointRetentionPolicy, boolean isExactlyOnce, int tolerableCpFailureNumber, boolean isUnalignedCheckpointsEnabled, long alignedCheckpointTimeout, long checkpointIdOfIgnoredInFlightData, boolean enableCheckpointsAfterTasksFinish) {
        if (checkpointInterval < 10L || checkpointTimeout < 10L || minPauseBetweenCheckpoints < 0L || maxConcurrentCheckpoints < 1 || tolerableCpFailureNumber < 0) {
            throw new IllegalArgumentException();
        }
        Preconditions.checkArgument(!isUnalignedCheckpointsEnabled || maxConcurrentCheckpoints <= 1, "maxConcurrentCheckpoints can't be > 1 if UnalignedCheckpoints enabled");
        this.checkpointInterval = checkpointInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
        this.checkpointRetentionPolicy = Preconditions.checkNotNull(checkpointRetentionPolicy);
        this.isExactlyOnce = isExactlyOnce;
        this.tolerableCheckpointFailureNumber = tolerableCpFailureNumber;
        this.isUnalignedCheckpointsEnabled = isUnalignedCheckpointsEnabled;
        this.alignedCheckpointTimeout = alignedCheckpointTimeout;
        this.checkpointIdOfIgnoredInFlightData = checkpointIdOfIgnoredInFlightData;
        this.enableCheckpointsAfterTasksFinish = enableCheckpointsAfterTasksFinish;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public boolean isCheckpointingEnabled() {
        return this.checkpointInterval > 0L && this.checkpointInterval < Long.MAX_VALUE;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public CheckpointRetentionPolicy getCheckpointRetentionPolicy() {
        return this.checkpointRetentionPolicy;
    }

    public boolean isExactlyOnce() {
        return this.isExactlyOnce;
    }

    public int getTolerableCheckpointFailureNumber() {
        return this.tolerableCheckpointFailureNumber;
    }

    public boolean isUnalignedCheckpointsEnabled() {
        return this.isUnalignedCheckpointsEnabled;
    }

    public long getAlignedCheckpointTimeout() {
        return this.alignedCheckpointTimeout;
    }

    public long getCheckpointIdOfIgnoredInFlightData() {
        return this.checkpointIdOfIgnoredInFlightData;
    }

    public boolean isEnableCheckpointsAfterTasksFinish() {
        return this.enableCheckpointsAfterTasksFinish;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointCoordinatorConfiguration that = (CheckpointCoordinatorConfiguration)o;
        return this.checkpointInterval == that.checkpointInterval && this.checkpointTimeout == that.checkpointTimeout && this.minPauseBetweenCheckpoints == that.minPauseBetweenCheckpoints && this.maxConcurrentCheckpoints == that.maxConcurrentCheckpoints && this.isExactlyOnce == that.isExactlyOnce && this.isUnalignedCheckpointsEnabled == that.isUnalignedCheckpointsEnabled && this.alignedCheckpointTimeout == that.alignedCheckpointTimeout && this.checkpointRetentionPolicy == that.checkpointRetentionPolicy && this.tolerableCheckpointFailureNumber == that.tolerableCheckpointFailureNumber && this.checkpointIdOfIgnoredInFlightData == that.checkpointIdOfIgnoredInFlightData && this.enableCheckpointsAfterTasksFinish == that.enableCheckpointsAfterTasksFinish;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkpointInterval, this.checkpointTimeout, this.minPauseBetweenCheckpoints, this.maxConcurrentCheckpoints, this.checkpointRetentionPolicy, this.isExactlyOnce, this.isUnalignedCheckpointsEnabled, this.alignedCheckpointTimeout, this.tolerableCheckpointFailureNumber, this.checkpointIdOfIgnoredInFlightData, this.enableCheckpointsAfterTasksFinish});
    }

    public String toString() {
        return "JobCheckpointingConfiguration{checkpointInterval=" + this.checkpointInterval + ", checkpointTimeout=" + this.checkpointTimeout + ", minPauseBetweenCheckpoints=" + this.minPauseBetweenCheckpoints + ", maxConcurrentCheckpoints=" + this.maxConcurrentCheckpoints + ", checkpointRetentionPolicy=" + (Object)((Object)this.checkpointRetentionPolicy) + ", isExactlyOnce=" + this.isExactlyOnce + ", isUnalignedCheckpoint=" + this.isUnalignedCheckpointsEnabled + ", alignedCheckpointTimeout=" + this.alignedCheckpointTimeout + ", tolerableCheckpointFailureNumber=" + this.tolerableCheckpointFailureNumber + ", checkpointIdOfIgnoredInFlightData=" + this.checkpointIdOfIgnoredInFlightData + ", enableCheckpointsAfterTasksFinish=" + this.enableCheckpointsAfterTasksFinish + '}';
    }

    public static CheckpointCoordinatorConfigurationBuilder builder() {
        return new CheckpointCoordinatorConfigurationBuilder();
    }

    public static class CheckpointCoordinatorConfigurationBuilder {
        private long checkpointInterval = 10L;
        private long checkpointTimeout = 10L;
        private long minPauseBetweenCheckpoints;
        private int maxConcurrentCheckpoints = 1;
        private CheckpointRetentionPolicy checkpointRetentionPolicy = CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION;
        private boolean isExactlyOnce = true;
        private int tolerableCheckpointFailureNumber;
        private boolean isUnalignedCheckpointsEnabled;
        private long alignedCheckpointTimeout = 0L;
        private long checkpointIdOfIgnoredInFlightData;
        private boolean enableCheckpointsAfterTasksFinish;

        public CheckpointCoordinatorConfiguration build() {
            return new CheckpointCoordinatorConfiguration(this.checkpointInterval, this.checkpointTimeout, this.minPauseBetweenCheckpoints, this.maxConcurrentCheckpoints, this.checkpointRetentionPolicy, this.isExactlyOnce, this.tolerableCheckpointFailureNumber, this.isUnalignedCheckpointsEnabled, this.alignedCheckpointTimeout, this.checkpointIdOfIgnoredInFlightData, this.enableCheckpointsAfterTasksFinish);
        }

        public CheckpointCoordinatorConfigurationBuilder setCheckpointInterval(long checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setCheckpointTimeout(long checkpointTimeout) {
            this.checkpointTimeout = checkpointTimeout;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setMinPauseBetweenCheckpoints(long minPauseBetweenCheckpoints) {
            this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setMaxConcurrentCheckpoints(int maxConcurrentCheckpoints) {
            this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setCheckpointRetentionPolicy(CheckpointRetentionPolicy checkpointRetentionPolicy) {
            this.checkpointRetentionPolicy = checkpointRetentionPolicy;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setExactlyOnce(boolean exactlyOnce) {
            this.isExactlyOnce = exactlyOnce;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setTolerableCheckpointFailureNumber(int tolerableCheckpointFailureNumber) {
            this.tolerableCheckpointFailureNumber = tolerableCheckpointFailureNumber;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setUnalignedCheckpointsEnabled(boolean unalignedCheckpointsEnabled) {
            this.isUnalignedCheckpointsEnabled = unalignedCheckpointsEnabled;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setAlignedCheckpointTimeout(long alignedCheckpointTimeout) {
            this.alignedCheckpointTimeout = alignedCheckpointTimeout;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setCheckpointIdOfIgnoredInFlightData(long checkpointIdOfIgnoredInFlightData) {
            this.checkpointIdOfIgnoredInFlightData = checkpointIdOfIgnoredInFlightData;
            return this;
        }

        public CheckpointCoordinatorConfigurationBuilder setEnableCheckpointsAfterTasksFinish(boolean enableCheckpointsAfterTasksFinish) {
            this.enableCheckpointsAfterTasksFinish = enableCheckpointsAfterTasksFinish;
            return this;
        }
    }
}

