/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.util.Arrays;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.SubpartitionRemoteCacheManager;

class RemoteCacheManager {
    private final SubpartitionRemoteCacheManager[] subpartitionCacheDataManagers;
    private final int[] subpartitionSegmentIds;

    public RemoteCacheManager(TieredStoragePartitionId partitionId, int numSubpartitions, TieredStorageMemoryManager storageMemoryManager, PartitionFileWriter partitionFileWriter) {
        this.subpartitionCacheDataManagers = new SubpartitionRemoteCacheManager[numSubpartitions];
        this.subpartitionSegmentIds = new int[numSubpartitions];
        for (int subpartitionId = 0; subpartitionId < numSubpartitions; ++subpartitionId) {
            this.subpartitionCacheDataManagers[subpartitionId] = new SubpartitionRemoteCacheManager(partitionId, subpartitionId, storageMemoryManager, partitionFileWriter);
        }
        Arrays.fill(this.subpartitionSegmentIds, -1);
    }

    void startSegment(int subpartitionId, int segmentId) {
        this.subpartitionCacheDataManagers[subpartitionId].startSegment(segmentId);
        this.subpartitionSegmentIds[subpartitionId] = segmentId;
    }

    void appendBuffer(Buffer finishedBuffer, int subpartitionId) {
        this.subpartitionCacheDataManagers[subpartitionId].addBuffer(finishedBuffer);
    }

    void finishSegment(int subpartitionId) {
        this.subpartitionCacheDataManagers[subpartitionId].finishSegment(this.subpartitionSegmentIds[subpartitionId]);
    }

    void close() {
        Arrays.stream(this.subpartitionCacheDataManagers).forEach(SubpartitionRemoteCacheManager::close);
    }

    void release() {
        Arrays.stream(this.subpartitionCacheDataManagers).forEach(SubpartitionRemoteCacheManager::release);
    }
}

