/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.BufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.HashSubpartitionBufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.HashSubpartitionBufferAccumulatorContext;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.util.Preconditions;

public class HashBufferAccumulator
implements BufferAccumulator,
HashSubpartitionBufferAccumulatorContext {
    private final TieredStorageMemoryManager memoryManager;
    private final HashSubpartitionBufferAccumulator[] hashSubpartitionBufferAccumulators;
    @Nullable
    private BiConsumer<TieredStorageSubpartitionId, List<Buffer>> accumulatedBufferFlusher;

    public HashBufferAccumulator(int numSubpartitions, int bufferSize, TieredStorageMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        this.hashSubpartitionBufferAccumulators = new HashSubpartitionBufferAccumulator[numSubpartitions];
        for (int i = 0; i < numSubpartitions; ++i) {
            this.hashSubpartitionBufferAccumulators[i] = new HashSubpartitionBufferAccumulator(new TieredStorageSubpartitionId(i), bufferSize, this);
        }
    }

    @Override
    public void setup(BiConsumer<TieredStorageSubpartitionId, List<Buffer>> accumulatedBufferFlusher) {
        this.accumulatedBufferFlusher = accumulatedBufferFlusher;
    }

    @Override
    public void receive(ByteBuffer record, TieredStorageSubpartitionId subpartitionId, Buffer.DataType dataType, boolean isBroadcast) throws IOException {
        this.getSubpartitionAccumulator(subpartitionId).append(record, dataType);
    }

    @Override
    public void close() {
        Arrays.stream(this.hashSubpartitionBufferAccumulators).forEach(HashSubpartitionBufferAccumulator::close);
    }

    @Override
    public BufferBuilder requestBufferBlocking() {
        return this.memoryManager.requestBufferBlocking(this);
    }

    @Override
    public void flushAccumulatedBuffers(TieredStorageSubpartitionId subpartitionId, List<Buffer> accumulatedBuffers) {
        Preconditions.checkNotNull(this.accumulatedBufferFlusher).accept(subpartitionId, accumulatedBuffers);
    }

    private HashSubpartitionBufferAccumulator getSubpartitionAccumulator(TieredStorageSubpartitionId subpartitionId) {
        return this.hashSubpartitionBufferAccumulators[subpartitionId.getSubpartitionId()];
    }
}

