/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.standalone;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.nonha.AbstractNonHaServices;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElection;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class StandaloneHaServices
extends AbstractNonHaServices {
    private final String resourceManagerAddress;
    private final String dispatcherAddress;
    private final String clusterRestEndpointAddress;

    public StandaloneHaServices(String resourceManagerAddress, String dispatcherAddress, String clusterRestEndpointAddress) {
        this.resourceManagerAddress = Preconditions.checkNotNull(resourceManagerAddress, "resourceManagerAddress");
        this.dispatcherAddress = Preconditions.checkNotNull(dispatcherAddress, "dispatcherAddress");
        this.clusterRestEndpointAddress = Preconditions.checkNotNull(clusterRestEndpointAddress, clusterRestEndpointAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.resourceManagerAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.dispatcherAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElection getResourceManagerLeaderElection() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElection(DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElection getDispatcherLeaderElection() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElection(DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService("UNKNOWN", DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(defaultJobManagerAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElection getJobManagerLeaderElection(JobID jobID) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElection(DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.clusterRestEndpointAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElection getClusterRestEndpointLeaderElection() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElection(DEFAULT_LEADER_ID);
        }
    }
}

