/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerSenderImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;

public final class HeartbeatServicesImpl
implements HeartbeatServices {
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    private final int failedRpcRequestsUntilUnreachable;

    public HeartbeatServicesImpl(long heartbeatInterval, long heartbeatTimeout) {
        this(heartbeatInterval, heartbeatTimeout, -1);
    }

    public HeartbeatServicesImpl(long heartbeatInterval, long heartbeatTimeout, int failedRpcRequestsUntilUnreachable) {
        Preconditions.checkArgument(0L < heartbeatInterval, "The heartbeat interval must be larger than 0.");
        Preconditions.checkArgument(heartbeatInterval <= heartbeatTimeout, "The heartbeat timeout should be larger or equal than the heartbeat interval.");
        Preconditions.checkArgument(failedRpcRequestsUntilUnreachable > 0 || failedRpcRequestsUntilUnreachable == -1, "The number of failed heartbeat RPC requests has to be larger than 0 or -1 (deactivated).");
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatTimeout = heartbeatTimeout;
        this.failedRpcRequestsUntilUnreachable = failedRpcRequestsUntilUnreachable;
    }

    @Override
    public <I, O> HeartbeatManager<I, O> createHeartbeatManager(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        return new HeartbeatManagerImpl<I, O>(this.heartbeatTimeout, this.failedRpcRequestsUntilUnreachable, resourceId, heartbeatListener, mainThreadExecutor, log);
    }

    @Override
    public <I, O> HeartbeatManager<I, O> createHeartbeatManagerSender(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        return new HeartbeatManagerSenderImpl<I, O>(this.heartbeatInterval, this.heartbeatTimeout, this.failedRpcRequestsUntilUnreachable, resourceId, heartbeatListener, mainThreadExecutor, log);
    }
}

