/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.JobVertexInputInfo;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.executiongraph.VertexInputInfoComputationUtils;
import org.apache.flink.runtime.executiongraph.failover.flip1.ResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.query.KvStateLocationRegistry;
import org.apache.flink.runtime.scheduler.InternalFailuresListener;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.util.OptionalFailure;

public interface ExecutionGraph
extends AccessExecutionGraph {
    public void start(@Nonnull ComponentMainThreadExecutor var1);

    public SchedulingTopology getSchedulingTopology();

    public void enableCheckpointing(CheckpointCoordinatorConfiguration var1, List<MasterTriggerRestoreHook<?>> var2, CheckpointIDCounter var3, CompletedCheckpointStore var4, StateBackend var5, CheckpointStorage var6, CheckpointStatsTracker var7, CheckpointsCleaner var8, String var9);

    @Nullable
    public CheckpointCoordinator getCheckpointCoordinator();

    public KvStateLocationRegistry getKvStateLocationRegistry();

    public void setJsonPlan(String var1);

    public Configuration getJobConfiguration();

    public Throwable getFailureCause();

    public Iterable<ExecutionJobVertex> getVerticesTopologically();

    public Iterable<ExecutionVertex> getAllExecutionVertices();

    @Override
    public ExecutionJobVertex getJobVertex(JobVertexID var1);

    public Map<JobVertexID, ExecutionJobVertex> getAllVertices();

    public long getNumberOfRestarts();

    public Map<IntermediateDataSetID, IntermediateResult> getAllIntermediateResults();

    public IntermediateResultPartition getResultPartitionOrThrow(IntermediateResultPartitionID var1);

    public Map<String, OptionalFailure<Accumulator<?, ?>>> aggregateUserAccumulators();

    public void updateAccumulators(AccumulatorSnapshot var1);

    public void setInternalTaskFailuresListener(InternalFailuresListener var1);

    public void attachJobGraph(List<JobVertex> var1, JobManagerJobMetricGroup var2) throws JobException;

    public void transitionToRunning();

    public void cancel();

    public void suspend(Throwable var1);

    public void failJob(Throwable var1, long var2);

    public CompletableFuture<JobStatus> getTerminationFuture();

    @VisibleForTesting
    public JobStatus waitUntilTerminal() throws InterruptedException;

    public boolean transitionState(JobStatus var1, JobStatus var2);

    public void incrementRestarts();

    public void initFailureCause(Throwable var1, long var2);

    public boolean updateState(TaskExecutionStateTransition var1);

    public Map<ExecutionAttemptID, Execution> getRegisteredExecutions();

    public void registerJobStatusListener(JobStatusListener var1);

    public ResultPartitionAvailabilityChecker getResultPartitionAvailabilityChecker();

    public int getNumFinishedVertices();

    @Nonnull
    public ComponentMainThreadExecutor getJobMasterMainThreadExecutor();

    default public void initializeJobVertex(ExecutionJobVertex ejv, long createTimestamp, JobManagerJobMetricGroup jobManagerJobMetricGroup) throws JobException {
        this.initializeJobVertex(ejv, createTimestamp, VertexInputInfoComputationUtils.computeVertexInputInfos(ejv, this.getAllIntermediateResults()::get), jobManagerJobMetricGroup);
    }

    public void initializeJobVertex(ExecutionJobVertex var1, long var2, Map<IntermediateDataSetID, JobVertexInputInfo> var4, JobManagerJobMetricGroup var5) throws JobException;

    public void notifyNewlyInitializedJobVertices(List<ExecutionJobVertex> var1);

    public Optional<String> findVertexWithAttempt(ExecutionAttemptID var1);

    public Optional<AccessExecution> findExecution(ExecutionAttemptID var1);
}

