/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application.executors;

import java.util.Collection;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.application.executors.WebSubmissionExecutorFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.util.Preconditions;

@Internal
public class WebSubmissionExecutorServiceLoader
implements PipelineExecutorServiceLoader {
    private final Collection<JobID> submittedJobIds;
    private final DispatcherGateway dispatcherGateway;

    public WebSubmissionExecutorServiceLoader(Collection<JobID> submittedJobIds, DispatcherGateway dispatcherGateway) {
        this.submittedJobIds = Preconditions.checkNotNull(submittedJobIds);
        this.dispatcherGateway = Preconditions.checkNotNull(dispatcherGateway);
    }

    @Override
    public PipelineExecutorFactory getExecutorFactory(Configuration configuration) {
        return new WebSubmissionExecutorFactory(this.submittedJobIds, this.dispatcherGateway);
    }

    @Override
    public Stream<String> getExecutorNames() {
        return Stream.builder().add("embedded").build();
    }
}

