/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class ClusterClientJobClientAdapter<ClusterID>
implements JobClient,
CoordinationRequestGateway {
    private final ClusterClientProvider<ClusterID> clusterClientProvider;
    private final JobID jobID;
    private final ClassLoader classLoader;

    public ClusterClientJobClientAdapter(ClusterClientProvider<ClusterID> clusterClientProvider, JobID jobID, ClassLoader classLoader) {
        this.jobID = Preconditions.checkNotNull(jobID);
        this.clusterClientProvider = Preconditions.checkNotNull(clusterClientProvider);
        this.classLoader = classLoader;
    }

    @Override
    public JobID getJobID() {
        return this.jobID;
    }

    @Override
    public CompletableFuture<JobStatus> getJobStatus() {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.getJobStatus(this.jobID));
    }

    @Override
    public CompletableFuture<Void> cancel() {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.cancel(this.jobID).thenApply(ignored -> null));
    }

    @Override
    public CompletableFuture<String> stopWithSavepoint(boolean advanceToEndOfEventTime, @Nullable String savepointDirectory, SavepointFormatType formatType) {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.stopWithSavepoint(this.jobID, advanceToEndOfEventTime, savepointDirectory, formatType));
    }

    @Override
    public CompletableFuture<String> triggerSavepoint(@Nullable String savepointDirectory, SavepointFormatType formatType) {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.triggerSavepoint(this.jobID, savepointDirectory, formatType));
    }

    @Override
    public CompletableFuture<Map<String, Object>> getAccumulators() {
        Preconditions.checkNotNull(this.classLoader);
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.getAccumulators(this.jobID, this.classLoader));
    }

    @Override
    public CompletableFuture<JobExecutionResult> getJobExecutionResult() {
        Preconditions.checkNotNull(this.classLoader);
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.requestJobResult(this.jobID).thenApply(jobResult -> {
            try {
                return jobResult.toJobExecutionResult(this.classLoader);
            }
            catch (Throwable t) {
                throw new CompletionException(new ProgramInvocationException("Job failed", this.jobID, t));
            }
        }));
    }

    @Override
    public CompletableFuture<CoordinationResponse> sendCoordinationRequest(OperatorID operatorId, CoordinationRequest request) {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.sendCoordinationRequest(this.jobID, operatorId, request));
    }

    @Override
    public void reportHeartbeat(long expiredTimestamp) {
        ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.reportHeartbeat(this.jobID, expiredTimestamp));
    }

    private static <T> CompletableFuture<T> bridgeClientRequest(ClusterClientProvider<?> clusterClientProvider, Function<ClusterClient<?>, CompletableFuture<T>> resultRetriever) {
        CompletableFuture<T> resultFuture;
        ClusterClient<?> clusterClient = clusterClientProvider.getClusterClient();
        try {
            resultFuture = resultRetriever.apply(clusterClient);
        }
        catch (Throwable throwable2) {
            IOUtils.closeQuietly(clusterClient::close);
            return FutureUtils.completedExceptionally(throwable2);
        }
        return resultFuture.whenCompleteAsync((jobResult, throwable) -> IOUtils.closeQuietly(clusterClient::close));
    }
}

