/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.core.execution.SavepointFormatType;

public class CancelOptions
extends CommandLineOptions {
    private final String[] args;
    private final boolean withSavepoint;
    private final String targetDirectory;
    private final SavepointFormatType formatType;

    public CancelOptions(CommandLine line) {
        super(line);
        this.args = line.getArgs();
        this.withSavepoint = line.hasOption(CliFrontendParser.CANCEL_WITH_SAVEPOINT_OPTION.getOpt());
        this.targetDirectory = line.getOptionValue(CliFrontendParser.CANCEL_WITH_SAVEPOINT_OPTION.getOpt());
        this.formatType = line.hasOption(CliFrontendParser.SAVEPOINT_FORMAT_OPTION) ? (SavepointFormatType)ConfigurationUtils.convertValue(line.getOptionValue(CliFrontendParser.SAVEPOINT_FORMAT_OPTION), SavepointFormatType.class) : SavepointFormatType.DEFAULT;
    }

    public String[] getArgs() {
        return this.args == null ? new String[]{} : this.args;
    }

    public boolean isWithSavepoint() {
        return this.withSavepoint;
    }

    public String getSavepointTargetDirectory() {
        return this.targetDirectory;
    }

    public SavepointFormatType getFormatType() {
        return this.formatType;
    }
}

