/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.materializedtable;

import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.gateway.service.materializedtable.MaterializedTableManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class MaterializedTableManagerTest {
    MaterializedTableManagerTest() {
    }

    @Test
    void testGetManuallyRefreshStatement() {
        ObjectIdentifier tableIdentifier = ObjectIdentifier.of((String)"catalog", (String)"database", (String)"my_materialized_table");
        String query = "SELECT * FROM my_source_table";
        Assertions.assertThat((String)MaterializedTableManager.getRefreshStatement((ObjectIdentifier)tableIdentifier, (String)query, Collections.emptyMap(), Collections.emptyMap())).isEqualTo("INSERT OVERWRITE `catalog`.`database`.`my_materialized_table`\n  SELECT * FROM (SELECT * FROM my_source_table)");
        LinkedHashMap<String, String> partitionSpec = new LinkedHashMap<String, String>();
        partitionSpec.put("k1", "v1");
        partitionSpec.put("k2", "v2");
        Assertions.assertThat((String)MaterializedTableManager.getRefreshStatement((ObjectIdentifier)tableIdentifier, (String)query, partitionSpec, Collections.emptyMap())).isEqualTo("INSERT OVERWRITE `catalog`.`database`.`my_materialized_table`\n  SELECT * FROM (SELECT * FROM my_source_table)\n  WHERE k1 = 'v1' AND k2 = 'v2'");
    }

    @Test
    void testGenerateInsertStatement() {
        ObjectIdentifier materializedTableIdentifier = ObjectIdentifier.of((String)"catalog", (String)"database", (String)"table");
        String definitionQuery = "SELECT * FROM source_table";
        String expectedStatement = "INSERT INTO `catalog`.`database`.`table`\nSELECT * FROM source_table";
        String actualStatement = MaterializedTableManager.getInsertStatement((ObjectIdentifier)materializedTableIdentifier, (String)definitionQuery, Collections.emptyMap());
        Assertions.assertThat((String)actualStatement).isEqualTo(expectedStatement);
    }

    @Test
    void testGenerateInsertStatementWithDynamicOptions() {
        ObjectIdentifier materializedTableIdentifier = ObjectIdentifier.of((String)"catalog", (String)"database", (String)"table");
        String definitionQuery = "SELECT * FROM source_table";
        HashMap<String, String> dynamicOptions = new HashMap<String, String>();
        dynamicOptions.put("option1", "value1");
        dynamicOptions.put("option2", "value2");
        String expectedStatement = "INSERT INTO `catalog`.`database`.`table` /*+ OPTIONS('option1'='value1', 'option2'='value2') */\nSELECT * FROM source_table";
        String actualStatement = MaterializedTableManager.getInsertStatement((ObjectIdentifier)materializedTableIdentifier, (String)definitionQuery, dynamicOptions);
        Assertions.assertThat((String)actualStatement).isEqualTo(expectedStatement);
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testGetPeriodRefreshPartition(TestSpec testSpec) {
        ObjectIdentifier objectIdentifier = ObjectIdentifier.of((String)"catalog", (String)"database", (String)"table");
        if (testSpec.errorMessage == null) {
            Map actualRefreshPartition = MaterializedTableManager.getPeriodRefreshPartition((String)testSpec.schedulerTime, (IntervalFreshness)testSpec.freshness, (ObjectIdentifier)objectIdentifier, testSpec.tableOptions, (ZoneId)ZoneId.systemDefault());
            Assertions.assertThat((Map)actualRefreshPartition).isEqualTo(testSpec.expectedRefreshPartition);
        } else {
            Assertions.assertThatThrownBy(() -> MaterializedTableManager.getPeriodRefreshPartition((String)testSpec.schedulerTime, (IntervalFreshness)testSpec.freshness, (ObjectIdentifier)objectIdentifier, testSpec.tableOptions, (ZoneId)ZoneId.systemDefault())).hasMessage(testSpec.errorMessage);
        }
    }

    static Stream<TestSpec> testData() {
        return Stream.of(TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofDay((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2023-12-31"), TestSpec.create().schedulerTime("2024-01-02 00:00:00").freshness(IntervalFreshness.ofDay((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2024-01-01"), TestSpec.create().schedulerTime("2024-01-02 00:00:00").freshness(IntervalFreshness.ofHour((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2024-01-01").expectedRefreshPartition("hour", "23"), TestSpec.create().schedulerTime("2024-01-02 01:00:00").freshness(IntervalFreshness.ofHour((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2024-01-02").expectedRefreshPartition("hour", "00"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofHour((String)"2")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "22"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofHour((String)"4")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "20"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofHour((String)"8")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "16"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofHour((String)"12")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "12"), TestSpec.create().schedulerTime("2024-01-01 12:00:00").freshness(IntervalFreshness.ofHour((String)"12")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2024-01-01").expectedRefreshPartition("hour", "00"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "59"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"2")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "58"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"4")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "56"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"5")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "55"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"6")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "54"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"10")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "50"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"12")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "48"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"15")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "45"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"30")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "30"), TestSpec.create().schedulerTime("2024-01-01 00:30:00").freshness(IntervalFreshness.ofMinute((String)"30")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2024-01-01").expectedRefreshPartition("hour", "00").expectedRefreshPartition("minute", "00"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofDay((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "00"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofDay((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "00").expectedRefreshPartition("minute", "00"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofHour((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23").expectedRefreshPartition("minute", "00"), TestSpec.create().schedulerTime("2024-01-01 01:00:00").freshness(IntervalFreshness.ofHour((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").tableOptions("partition.fields.minute.date-formatter", "mm").expectedRefreshPartition("day", "2024-01-01").expectedRefreshPartition("hour", "00").expectedRefreshPartition("minute", "00"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofHour((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2023-12-31"), TestSpec.create().schedulerTime("2024-01-01 01:00:00").freshness(IntervalFreshness.ofHour((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2024-01-01"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofHour((String)"2")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2023-12-31"), TestSpec.create().schedulerTime("2024-01-01 02:00:00").freshness(IntervalFreshness.ofHour((String)"2")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2024-01-01"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofHour((String)"4")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2023-12-31"), TestSpec.create().schedulerTime("2024-01-01 04:00:00").freshness(IntervalFreshness.ofHour((String)"4")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2024-01-01"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"2")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"4")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"15")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").expectedRefreshPartition("day", "2023-12-31").expectedRefreshPartition("hour", "23"), TestSpec.create().schedulerTime("2024-01-01 00:00:00").freshness(IntervalFreshness.ofMinute((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2023-12-31"), TestSpec.create().schedulerTime("2024-01-01 00:01:00").freshness(IntervalFreshness.ofMinute((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").expectedRefreshPartition("day", "2024-01-01"), TestSpec.create().schedulerTime(null).freshness(IntervalFreshness.ofDay((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").errorMessage("The scheduler time must not be null during the periodic refresh of the materialized table `catalog`.`database`.`table`."), TestSpec.create().schedulerTime("2024-01-01").freshness(IntervalFreshness.ofDay((String)"1")).tableOptions("partition.fields.day.date-formatter", "yyyy-MM-dd").tableOptions("partition.fields.hour.date-formatter", "HH").errorMessage("Failed to parse a valid partition value for the field 'day' in materialized table `catalog`.`database`.`table` using the scheduler time '2024-01-01' based on the date format 'yyyy-MM-dd HH:mm:ss'."));
    }

    private static class TestSpec {
        private String schedulerTime;
        private IntervalFreshness freshness;
        private final Map<String, String> tableOptions = new HashMap<String, String>();
        private final Map<String, String> expectedRefreshPartition = new HashMap<String, String>();
        @Nullable
        private String errorMessage;

        private TestSpec() {
        }

        public static TestSpec create() {
            return new TestSpec();
        }

        public TestSpec schedulerTime(String schedulerTime) {
            this.schedulerTime = schedulerTime;
            return this;
        }

        public TestSpec freshness(IntervalFreshness freshness) {
            this.freshness = freshness;
            return this;
        }

        public TestSpec tableOptions(String key, String value) {
            this.tableOptions.put(key, value);
            return this;
        }

        public TestSpec expectedRefreshPartition(String key, String value) {
            this.expectedRefreshPartition.put(key, value);
            return this;
        }

        public TestSpec errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public String toString() {
            return "TestSpec{schedulerTime=" + this.schedulerTime + ", freshness=" + String.valueOf(this.freshness) + ", tableOptions=" + String.valueOf(this.tableOptions) + ", expectedRefreshPartition=" + String.valueOf(this.expectedRefreshPartition) + "}";
        }
    }
}

