/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.workflow;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.gateway.workflow.WorkflowInfo;
import org.apache.flink.table.gateway.workflow.scheduler.QuartzSchedulerUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.quartz.JobKey;

public class QuartzSchedulerUtilsTest {
    @Test
    void testJsonSerDe() {
        String identifier = ObjectIdentifier.of((String)"a", (String)"b", (String)"c").asSerializableString();
        HashMap<String, String> dynamicOptions = new HashMap<String, String>();
        dynamicOptions.put("k1", "v1");
        dynamicOptions.put("k2", "v2");
        HashMap<String, String> initConfig = new HashMap<String, String>();
        initConfig.put("k3", "v4");
        initConfig.put("k4", "v5");
        HashMap<String, String> executionConfig = new HashMap<String, String>();
        executionConfig.put("k5", "v5");
        executionConfig.put("k6", "v6");
        String url = "http://localhost:8083";
        WorkflowInfo expected = new WorkflowInfo(identifier, dynamicOptions, initConfig, executionConfig, url);
        WorkflowInfo serde = (WorkflowInfo)QuartzSchedulerUtils.fromJson((String)QuartzSchedulerUtils.toJson((Object)expected), WorkflowInfo.class);
        Assertions.assertThat((Object)serde).isEqualTo((Object)expected);
    }

    @Test
    void testConvertDateToString() {
        LocalDateTime localDateTime = LocalDateTime.of(2024, 5, 22, 12, 30, 15);
        Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        String actual = QuartzSchedulerUtils.dateToString((Date)date);
        String expected = "2024-05-22 12:30:15";
        Assertions.assertThat((String)actual).isEqualTo(expected);
    }

    @Test
    void testGetJobKey() {
        String materializedTableIdentifier = "`a`.`b`.`c`";
        JobKey actual = QuartzSchedulerUtils.getJobKey((String)materializedTableIdentifier);
        Assertions.assertThat((String)actual.getName()).isEqualTo("quartz_job_" + materializedTableIdentifier);
        Assertions.assertThat((String)actual.getGroup()).isEqualTo("default_group");
    }
}

