/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.AbstractSqlGatewayStatementITCase;
import org.apache.flink.table.gateway.utils.SqlScriptReader;
import org.apache.flink.table.gateway.utils.TestSqlStatement;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.table.utils.print.TableauStyle;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractSqlGatewayStatementITCaseBase
extends AbstractTestBaseJUnit4 {
    private static final String RESOURCE_DIR = "sql/";
    private static final Pattern PATTERN = Pattern.compile(".*\\.q$");
    protected final Map<String, String> replaceVars = new HashMap<String, String>();
    @Parameter
    public TestParameters parameters;

    @Parameters(name="parameters={0}")
    public static List<TestParameters> parameters() throws Exception {
        return AbstractSqlGatewayStatementITCaseBase.listFlinkSqlTests().stream().map(TestParameters::new).collect(Collectors.toList());
    }

    @BeforeEach
    public void before(@TempDir Path temporaryFolder) throws Exception {
        this.replaceVars.put("$VAR_STREAMING_PATH", Files.createDirectory(temporaryFolder.resolve("streaming"), new FileAttribute[0]).toFile().getPath());
        this.replaceVars.put("$VAR_STREAMING_PATH2", Files.createDirectory(temporaryFolder.resolve("streaming2"), new FileAttribute[0]).toFile().getPath());
        this.replaceVars.put("$VAR_STREAMING_PATH3", Files.createDirectory(temporaryFolder.resolve("streaming3"), new FileAttribute[0]).toFile().getPath());
        this.replaceVars.put("$VAR_BATCH_PATH", Files.createDirectory(temporaryFolder.resolve("batch"), new FileAttribute[0]).toFile().getPath());
        this.replaceVars.put("$VAR_BATCH_CTAS_PATH", Files.createDirectory(temporaryFolder.resolve("batch_ctas"), new FileAttribute[0]).toFile().getPath());
        this.replaceVars.put("$VAR_STREAMING_PLAN_PATH", Files.createDirectory(temporaryFolder.resolve("streaming_compiled_plan"), new FileAttribute[0]).toFile().getPath());
        this.replaceVars.put("$VAR_STREAMING_PLAN_RELATIVE_PATH", new File(".").getCanonicalFile().toPath().relativize(Paths.get(this.replaceVars.get("$VAR_STREAMING_PLAN_PATH"), new String[0])).toString());
    }

    @TestTemplate
    public void testFlinkSqlStatements() throws Exception {
        this.prepareEnvironment();
        if (this.skip()) {
            return;
        }
        this.runTest(this.parameters.getSqlPath());
    }

    protected void runTest(String sqlPath) throws Exception {
        String in = this.getInputFromPath(sqlPath);
        List<TestSqlStatement> testSqlStatements = SqlScriptReader.parseSqlScript(in);
        Assertions.assertThat((String)String.join((CharSequence)"", this.runStatements(testSqlStatements))).isEqualTo(in);
    }

    protected abstract boolean isStreaming() throws Exception;

    protected abstract String runStatements(List<TestSqlStatement> var1) throws Exception;

    protected boolean skip() {
        return false;
    }

    protected void prepareEnvironment() throws Exception {
    }

    protected String getInputFromPath(String sqlPath) throws IOException {
        String[] keys = this.replaceVars.keySet().toArray(new String[0]);
        String[] values = (String[])Arrays.stream(keys).map(this.replaceVars::get).toArray(String[]::new);
        return StringUtils.replaceEach((String)IOUtils.toString((InputStream)((InputStream)Preconditions.checkNotNull((Object)AbstractSqlGatewayStatementITCase.class.getResourceAsStream("/" + sqlPath))), (Charset)StandardCharsets.UTF_8), (String[])keys, (String[])values);
    }

    protected static List<String> listFlinkSqlTests() throws Exception {
        File jarFile = new File(AbstractSqlGatewayStatementITCase.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (jarFile.isFile()) {
            ArrayList<String> files = new ArrayList<String>();
            try (JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(RESOURCE_DIR) || !PATTERN.matcher(name).matches()) continue;
                    files.add(name);
                }
            }
            return files;
        }
        return AbstractSqlGatewayStatementITCaseBase.listTestSpecInTheSameModule(RESOURCE_DIR);
    }

    protected static List<String> listTestSpecInTheSameModule(String resourceDir) throws Exception {
        return IOUtils.readLines((InputStream)((InputStream)Preconditions.checkNotNull((Object)AbstractSqlGatewayStatementITCase.class.getClassLoader().getResourceAsStream(resourceDir))), (Charset)StandardCharsets.UTF_8).stream().map(name -> Paths.get(resourceDir, name).toString()).collect(Collectors.toList());
    }

    protected String toString(StatementType type, ResolvedSchema schema, RowDataToStringConverter converter, Iterator<RowData> iterator) throws Exception {
        if (type.equals((Object)StatementType.EXPLAIN) || type.equals((Object)StatementType.SHOW_CREATE)) {
            StringBuilder sb = new StringBuilder();
            while (iterator.hasNext()) {
                sb.append(iterator.next().getString(0).toString());
            }
            return Tag.OK.addTag(TableTestUtil.replaceStreamNodeId((String)TableTestUtil.replaceNodeIdInOperator((String)sb.toString())) + "\n");
        }
        if (schema.getColumn(0).map(col -> col.getName().equals("job id")).orElse(false).booleanValue()) {
            return Tag.INFO.addTag("Job ID:\n");
        }
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        TableauStyle style = PrintStyle.tableauWithDataInferredColumnWidths((ResolvedSchema)schema, (RowDataToStringConverter)converter, (int)Integer.MAX_VALUE, (boolean)true, (type.equals((Object)StatementType.QUERY) && this.isStreaming() ? 1 : 0) != 0);
        PrintWriter writer = new PrintWriter(outContent);
        style.print(iterator, writer);
        return Tag.OK.addTag(outContent.toString());
    }

    protected String removeRowNumber(String s) {
        return s.replaceAll("at line \\d+", "at line 0");
    }

    public static enum StatementType {
        SHOW_CREATE("SHOW CREATE"),
        EXPLAIN("EXPLAIN"),
        QUERY("SELECT"),
        OTHERS;

        private final String beginWith;

        private StatementType(String beginWith) {
            this.beginWith = beginWith;
        }

        private StatementType() {
            this("");
        }

        public static StatementType match(String sql) {
            String processed = sql.trim().toUpperCase();
            if (processed.startsWith(StatementType.SHOW_CREATE.beginWith)) {
                return SHOW_CREATE;
            }
            if (processed.startsWith(StatementType.EXPLAIN.beginWith)) {
                return EXPLAIN;
            }
            if (processed.startsWith(StatementType.QUERY.beginWith)) {
                return QUERY;
            }
            return OTHERS;
        }
    }

    public static enum Tag {
        INFO("!info"),
        OK("!ok"),
        ERROR("!error");

        private final String tag;

        private Tag(String tag) {
            this.tag = tag;
        }

        public String addTag(String content) {
            return "!output\n" + content + this.tag + "\n";
        }
    }

    protected static class TestParameters {
        protected final String sqlPath;

        public TestParameters(String sqlPath) {
            this.sqlPath = sqlPath;
        }

        public String getSqlPath() {
            return this.sqlPath;
        }

        public String toString() {
            return "TestParameters{sqlPath='" + this.sqlPath + "'}";
        }
    }
}

