/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.gateway.rest.util.RowDataLocalTimeZoneConverter;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RowDataLocalTimeZoneConverterTest {
    @Test
    public void testCheckHasTimeZoneData() {
        List<IntType> logicalTypeListWithoutTimestamp = Collections.singletonList(new IntType());
        List<LocalZonedTimestampType> logicalTypeListWithTimestamp = Collections.singletonList(new LocalZonedTimestampType());
        List<LogicalType> logicalTypeListWithMapTimestamp = Arrays.asList(new IntType(), new MapType((LogicalType)new VarCharType(100), (LogicalType)new MapType((LogicalType)new VarCharType(20), (LogicalType)new LocalZonedTimestampType())));
        List<LogicalType> logicalTypeListWithMultisetTimestamp = Arrays.asList(new IntType(), new MultisetType((LogicalType)new LocalZonedTimestampType()));
        List<LogicalType> logicalTypeListWithRowTimestamp = Arrays.asList(new VarCharType(100), new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new LocalZonedTimestampType()), new RowType.RowField("b", (LogicalType)new IntType()))));
        Assertions.assertFalse((boolean)new RowDataLocalTimeZoneConverter(logicalTypeListWithoutTimestamp, TimeZone.getTimeZone("Asia/Shanghai")).hasTimeZoneData());
        Assertions.assertTrue((boolean)new RowDataLocalTimeZoneConverter(logicalTypeListWithTimestamp, TimeZone.getTimeZone("Asia/Shanghai")).hasTimeZoneData());
        Assertions.assertTrue((boolean)new RowDataLocalTimeZoneConverter(logicalTypeListWithMapTimestamp, TimeZone.getTimeZone("Asia/Shanghai")).hasTimeZoneData());
        Assertions.assertTrue((boolean)new RowDataLocalTimeZoneConverter(logicalTypeListWithMultisetTimestamp, TimeZone.getTimeZone("Asia/Shanghai")).hasTimeZoneData());
        Assertions.assertTrue((boolean)new RowDataLocalTimeZoneConverter(logicalTypeListWithRowTimestamp, TimeZone.getTimeZone("Asia/Shanghai")).hasTimeZoneData());
    }

    @Test
    public void testSimpleTimestampWithLocalZone() {
        List<LocalZonedTimestampType> logicalTypeList = Collections.singletonList(new LocalZonedTimestampType());
        RowDataLocalTimeZoneConverter converter1 = new RowDataLocalTimeZoneConverter(logicalTypeList, TimeZone.getTimeZone("Asia/Shanghai"));
        RowDataLocalTimeZoneConverter converter2 = new RowDataLocalTimeZoneConverter(logicalTypeList, TimeZone.getTimeZone("Europe/Berlin"));
        GenericRowData data = GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)100000000000L)});
        RowData data1 = converter1.convertTimeZoneRowData((RowData)data);
        RowData data2 = converter2.convertTimeZoneRowData((RowData)data);
        Assertions.assertEquals((Object)data.toString(), (Object)"+I(1973-03-03T09:46:40)");
        Assertions.assertEquals((Object)data1.toString(), (Object)"+I(1973-03-03T17:46:40)");
        Assertions.assertEquals((Object)data2.toString(), (Object)"+I(1973-03-03T10:46:40)");
    }

    @Test
    public void testComplexTimestampWithLocalZone() {
        List<LogicalType> logicalTypeList = Arrays.asList(new IntType(), new MapType((LogicalType)new VarCharType(100), (LogicalType)new MapType((LogicalType)new VarCharType(20), (LogicalType)new LocalZonedTimestampType())));
        RowDataLocalTimeZoneConverter converter1 = new RowDataLocalTimeZoneConverter(logicalTypeList, TimeZone.getTimeZone("Asia/Shanghai"));
        RowDataLocalTimeZoneConverter converter2 = new RowDataLocalTimeZoneConverter(logicalTypeList, TimeZone.getTimeZone("Europe/Berlin"));
        HashMap<StringData, TimestampData> timestampMapValue = new HashMap<StringData, TimestampData>();
        timestampMapValue.put(StringData.fromString((String)"123"), TimestampData.fromEpochMillis((long)100000000000L));
        HashMap<StringData, GenericMapData> timestampMapData = new HashMap<StringData, GenericMapData>();
        timestampMapData.put(StringData.fromString((String)"321"), new GenericMapData(timestampMapValue));
        GenericRowData data = GenericRowData.of((Object[])new Object[]{100, new GenericMapData(timestampMapData)});
        RowData data1 = converter1.convertTimeZoneRowData((RowData)data);
        RowData data2 = converter2.convertTimeZoneRowData((RowData)data);
        Assertions.assertEquals((int)2, (int)data.getArity());
        Assertions.assertEquals((int)2, (int)data1.getArity());
        Assertions.assertEquals((int)2, (int)data2.getArity());
        Assertions.assertEquals((long)100L, (long)data.getInt(0));
        Assertions.assertEquals((long)100L, (long)data1.getInt(0));
        Assertions.assertEquals((long)100L, (long)data2.getInt(0));
        MapData mapData = data.getMap(1);
        MapData mapData1 = data1.getMap(1);
        MapData mapData2 = data2.getMap(1);
        Assertions.assertEquals((int)1, (int)mapData.size());
        Assertions.assertEquals((int)1, (int)mapData1.size());
        Assertions.assertEquals((int)1, (int)mapData2.size());
        Assertions.assertEquals((Object)"321", (Object)mapData.keyArray().getString(0).toString());
        Assertions.assertEquals((Object)"321", (Object)mapData1.keyArray().getString(0).toString());
        Assertions.assertEquals((Object)"321", (Object)mapData2.keyArray().getString(0).toString());
        MapData mapValue = mapData.valueArray().getMap(0);
        MapData mapValue1 = mapData1.valueArray().getMap(0);
        MapData mapValue2 = mapData2.valueArray().getMap(0);
        Assertions.assertEquals((int)1, (int)mapValue.size());
        Assertions.assertEquals((int)1, (int)mapValue1.size());
        Assertions.assertEquals((int)1, (int)mapValue2.size());
        Assertions.assertEquals((Object)"123", (Object)mapValue.keyArray().getString(0).toString());
        Assertions.assertEquals((Object)"123", (Object)mapValue1.keyArray().getString(0).toString());
        Assertions.assertEquals((Object)"123", (Object)mapValue2.keyArray().getString(0).toString());
        Assertions.assertEquals((Object)"1973-03-03T09:46:40", (Object)mapValue.valueArray().getTimestamp(0, 0).toString());
        Assertions.assertEquals((Object)"1973-03-03T17:46:40", (Object)mapValue1.valueArray().getTimestamp(0, 0).toString());
        Assertions.assertEquals((Object)"1973-03-03T10:46:40", (Object)mapValue2.valueArray().getTimestamp(0, 0).toString());
    }
}

