/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.service.SqlGatewayServiceImpl;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.session.SessionManager;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TemporaryFolder;

public class SqlGatewayServiceExtension
implements BeforeAllCallback,
AfterAllCallback {
    private SqlGatewayService service;
    private SessionManager sessionManager;
    private TemporaryFolder temporaryFolder;
    private final Supplier<Configuration> configSupplier;
    private final Function<DefaultContext, SessionManager> sessionManagerCreator;

    public SqlGatewayServiceExtension(Supplier<Configuration> configSupplier) {
        this(configSupplier, SessionManager::create);
    }

    public SqlGatewayServiceExtension(Supplier<Configuration> configSupplier, Function<DefaultContext, SessionManager> sessionManagerCreator) {
        this.configSupplier = configSupplier;
        this.sessionManagerCreator = sessionManagerCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext context) throws Exception {
        Map<String, String> originalEnv = System.getenv();
        try {
            this.temporaryFolder = new TemporaryFolder();
            this.temporaryFolder.create();
            File confFolder = this.temporaryFolder.newFolder("conf");
            File confYaml = new File(confFolder, "config.yaml");
            if (!confYaml.createNewFile()) {
                throw new IOException("Can't create testing config.yaml file.");
            }
            FileUtils.write((File)confYaml, (CharSequence)this.getFlinkConfContent(this.configSupplier.get().toMap()), (Charset)StandardCharsets.UTF_8);
            HashMap<String, String> map = new HashMap<String, String>(System.getenv());
            map.put("FLINK_CONF_DIR", confFolder.getAbsolutePath());
            CommonTestUtils.setEnv(map);
            this.sessionManager = this.sessionManagerCreator.apply(DefaultContext.load((Configuration)new Configuration(), Collections.emptyList(), (boolean)true));
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        this.service = new SqlGatewayServiceImpl(this.sessionManager);
        this.sessionManager.start();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.sessionManager != null) {
            this.sessionManager.stop();
        }
        this.temporaryFolder.delete();
    }

    public SqlGatewayService getService() {
        return this.service;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    private String getFlinkConfContent(Map<String, String> flinkConf) {
        StringBuilder sb = new StringBuilder();
        flinkConf.forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append("\n"));
        return sb.toString();
    }
}

