/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.gateway.AbstractMaterializedTableStatementITCase;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.rest.header.materializedtable.RefreshMaterializedTableHeaders;
import org.apache.flink.table.gateway.rest.header.statement.FetchResultsHeaders;
import org.apache.flink.table.gateway.rest.message.materializedtable.RefreshMaterializedTableParameters;
import org.apache.flink.table.gateway.rest.message.materializedtable.RefreshMaterializedTableRequestBody;
import org.apache.flink.table.gateway.rest.message.materializedtable.RefreshMaterializedTableResponseBody;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsMessageParameters;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsResponseBody;
import org.apache.flink.table.gateway.rest.util.RowFormat;
import org.apache.flink.table.gateway.rest.util.TestingRestClient;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SqlGatewayRestEndpointMaterializedTableITCase
extends AbstractMaterializedTableStatementITCase {
    private static TestingRestClient restClient;

    @BeforeAll
    static void setup() throws Exception {
        restClient = TestingRestClient.getTestingRestClient();
    }

    @Test
    void testStaticPartitionRefreshMaterializedTableViaRestAPI() throws Exception {
        ArrayList<Row> data = new ArrayList<Row>();
        data.add(Row.of((Object[])new Object[]{1L, 1L, 1L, "2024-01-01"}));
        data.add(Row.of((Object[])new Object[]{2L, 2L, 2L, "2024-01-02"}));
        this.createAndVerifyCreateMaterializedTableWithData("my_materialized_table", data, Collections.emptyMap(), CatalogMaterializedTable.RefreshMode.CONTINUOUS);
        RefreshMaterializedTableHeaders refreshMaterializedTableHeaders = new RefreshMaterializedTableHeaders();
        RefreshMaterializedTableParameters refreshMaterializedTableParameters = new RefreshMaterializedTableParameters(this.sessionHandle, ObjectIdentifier.of((String)this.fileSystemCatalogName, (String)"test_db", (String)"my_materialized_table").asSerializableString());
        HashMap<String, String> staticPartitions = new HashMap<String, String>();
        staticPartitions.put("ds", "2024-01-02");
        RefreshMaterializedTableRequestBody refreshMaterializedTableRequestBody = new RefreshMaterializedTableRequestBody(false, null, Collections.emptyMap(), staticPartitions, Collections.emptyMap());
        long startTime = System.currentTimeMillis();
        RefreshMaterializedTableResponseBody response = (RefreshMaterializedTableResponseBody)restClient.sendRequest(SQL_GATEWAY_REST_ENDPOINT_EXTENSION.getTargetAddress(), SQL_GATEWAY_REST_ENDPOINT_EXTENSION.getTargetPort(), (MessageHeaders)refreshMaterializedTableHeaders, (MessageParameters)refreshMaterializedTableParameters, (RequestBody)refreshMaterializedTableRequestBody).get();
        Assertions.assertThat((String)response.getOperationHandle()).isNotNull();
        OperationHandle operationHandle = new OperationHandle(UUID.fromString(response.getOperationHandle()));
        CommonTestUtils.waitUtil(() -> SQL_GATEWAY_SERVICE_EXTENSION.getService().getOperationInfo(this.sessionHandle, operationHandle).getStatus().isTerminalStatus(), (Duration)Duration.ofSeconds(100L), (String)"Failed to wait operation finish.");
        FetchResultsResponseBody fetchResultsResponseBody = this.fetchResults(this.sessionHandle, operationHandle);
        List results = fetchResultsResponseBody.getResults().getData();
        String jobId = ((RowData)results.get(0)).getString(0).toString();
        this.verifyRefreshJobCreated(this.restClusterClient, jobId, startTime);
        GenericMapData clusterInfo = (GenericMapData)((RowData)results.get(0)).getMap(1);
        Assertions.assertThat((Object)clusterInfo.get((Object)StringData.fromString((String)DeploymentOptions.TARGET.key()))).isEqualTo((Object)StringData.fromString((String)"remote"));
    }

    @Test
    void testPeriodicRefreshMaterializedTableViaRestAPI() throws Exception {
        ArrayList<Row> data = new ArrayList<Row>();
        data.add(Row.of((Object[])new Object[]{1L, 1L, 1L, "2024-01-01"}));
        data.add(Row.of((Object[])new Object[]{2L, 2L, 2L, "2024-01-02"}));
        this.createAndVerifyCreateMaterializedTableWithData("my_materialized_table", data, Collections.singletonMap("ds", "yyyy-MM-dd"), CatalogMaterializedTable.RefreshMode.CONTINUOUS);
        RefreshMaterializedTableHeaders refreshMaterializedTableHeaders = new RefreshMaterializedTableHeaders();
        RefreshMaterializedTableParameters refreshMaterializedTableParameters = new RefreshMaterializedTableParameters(this.sessionHandle, ObjectIdentifier.of((String)this.fileSystemCatalogName, (String)"test_db", (String)"my_materialized_table").asSerializableString());
        HashMap staticPartitions = new HashMap();
        RefreshMaterializedTableRequestBody refreshMaterializedTableRequestBody = new RefreshMaterializedTableRequestBody(true, "2024-01-02 00:00:00", Collections.emptyMap(), staticPartitions, Collections.emptyMap());
        long startTime = System.currentTimeMillis();
        RefreshMaterializedTableResponseBody response = (RefreshMaterializedTableResponseBody)restClient.sendRequest(SQL_GATEWAY_REST_ENDPOINT_EXTENSION.getTargetAddress(), SQL_GATEWAY_REST_ENDPOINT_EXTENSION.getTargetPort(), (MessageHeaders)refreshMaterializedTableHeaders, (MessageParameters)refreshMaterializedTableParameters, (RequestBody)refreshMaterializedTableRequestBody).get();
        Assertions.assertThat((String)response.getOperationHandle()).isNotNull();
        OperationHandle operationHandle = new OperationHandle(UUID.fromString(response.getOperationHandle()));
        CommonTestUtils.waitUtil(() -> SQL_GATEWAY_SERVICE_EXTENSION.getService().getOperationInfo(this.sessionHandle, operationHandle).getStatus().isTerminalStatus(), (Duration)Duration.ofSeconds(100L), (String)"Failed to wait operation finish.");
        FetchResultsResponseBody fetchResultsResponseBody = this.fetchResults(this.sessionHandle, operationHandle);
        List results = fetchResultsResponseBody.getResults().getData();
        String jobId = ((RowData)results.get(0)).getString(0).toString();
        this.verifyRefreshJobCreated(this.restClusterClient, jobId, startTime);
        GenericMapData clusterInfo = (GenericMapData)((RowData)results.get(0)).getMap(1);
        Assertions.assertThat((Object)clusterInfo.get((Object)StringData.fromString((String)DeploymentOptions.TARGET.key()))).isEqualTo((Object)StringData.fromString((String)"remote"));
    }

    FetchResultsResponseBody fetchResults(SessionHandle sessionHandle, OperationHandle operationHandle) throws Exception {
        FetchResultsMessageParameters fetchResultsMessageParameters = new FetchResultsMessageParameters(sessionHandle, operationHandle, Long.valueOf(0L), RowFormat.JSON);
        CompletableFuture response = restClient.sendRequest(SQL_GATEWAY_REST_ENDPOINT_EXTENSION.getTargetAddress(), SQL_GATEWAY_REST_ENDPOINT_EXTENSION.getTargetPort(), (MessageHeaders)FetchResultsHeaders.getDefaultInstance(), (MessageParameters)fetchResultsMessageParameters, (RequestBody)EmptyRequestBody.getInstance());
        return (FetchResultsResponseBody)response.get();
    }
}

