/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.header.statement;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.table.gateway.rest.header.SqlGatewayMessageHeaders;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsMessageParameters;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsResponseBody;
import org.apache.flink.table.gateway.rest.util.RowFormat;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class FetchResultsHeaders
implements SqlGatewayMessageHeaders<EmptyRequestBody, FetchResultsResponseBody, FetchResultsMessageParameters> {
    private static final FetchResultsHeaders INSTANCE_V1 = new FetchResultsHeaders(SqlGatewayRestAPIVersion.V1);
    private static final FetchResultsHeaders DEFAULT_INSTANCE = new FetchResultsHeaders(SqlGatewayRestAPIVersion.getDefaultVersion());
    public static final String URL = "/sessions/:session_handle/operations/:operation_handle/result/:token";
    private final SqlGatewayRestAPIVersion version;

    private FetchResultsHeaders(SqlGatewayRestAPIVersion version) {
        this.version = version;
    }

    public static FetchResultsHeaders getInstanceV1() {
        return INSTANCE_V1;
    }

    public static FetchResultsHeaders getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    @Nullable
    public static String buildNextUri(SqlGatewayRestAPIVersion version, String sessionId, String operationId, Long nextToken, RowFormat rowFormat) {
        if (nextToken == null) {
            return null;
        }
        if (version == SqlGatewayRestAPIVersion.V1) {
            return String.format("/%s/sessions/%s/operations/%s/result/%s", version.getURLVersionPrefix(), sessionId, operationId, nextToken);
        }
        return String.format("/%s/sessions/%s/operations/%s/result/%s?rowFormat=%s", new Object[]{version.getURLVersionPrefix(), sessionId, operationId, nextToken, rowFormat});
    }

    public Class<FetchResultsResponseBody> getResponseClass() {
        return FetchResultsResponseBody.class;
    }

    public HttpResponseStatus getResponseStatusCode() {
        return HttpResponseStatus.OK;
    }

    public String getDescription() {
        return "Fetch results of Operation.";
    }

    public HttpMethodWrapper getHttpMethod() {
        return HttpMethodWrapper.GET;
    }

    public String getTargetRestEndpointURL() {
        return URL;
    }

    @Override
    public Collection<? extends RestAPIVersion<?>> getSupportedAPIVersions() {
        if (this.version == SqlGatewayRestAPIVersion.V1) {
            return Collections.singleton(SqlGatewayRestAPIVersion.V1);
        }
        return Arrays.stream(SqlGatewayRestAPIVersion.values()).filter(SqlGatewayRestAPIVersion::isStableVersion).filter(version -> version != SqlGatewayRestAPIVersion.V1).collect(Collectors.toList());
    }

    public Class<EmptyRequestBody> getRequestClass() {
        return EmptyRequestBody.class;
    }

    public FetchResultsMessageParameters getUnresolvedMessageParameters() {
        return new FetchResultsMessageParameters(this.version);
    }

    public String operationId() {
        return "fetchResults";
    }
}

