/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.utils;

import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.MockedEndpointVersion;
import org.apache.flink.table.gateway.service.SqlGatewayServiceImpl;

public class SqlGatewayServiceTestUtil {
    public static SessionHandle createInitializedSession(SqlGatewayService service) {
        SessionEnvironment environment = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("cat1")).registerCatalog("cat2", (Catalog)new GenericInMemoryCatalog("cat2")).build();
        SessionHandle sessionHandle = service.openSession(environment);
        TableEnvironmentInternal tableEnv = ((SqlGatewayServiceImpl)service).getSession(sessionHandle).createExecutor().getTableEnvironment();
        tableEnv.executeSql("CREATE DATABASE cat1.db1");
        tableEnv.executeSql("CREATE TEMPORARY TABLE cat1.db1.tbl1 WITH ('connector' = 'values')");
        tableEnv.executeSql("CREATE TABLE cat1.db1.tbl2 WITH('connector' = 'values')");
        tableEnv.executeSql("CREATE TEMPORARY VIEW cat1.db1.tbl3 AS SELECT 1");
        tableEnv.executeSql("CREATE VIEW cat1.db1.tbl4 AS SELECT 1");
        tableEnv.executeSql("CREATE DATABASE cat1.db2");
        tableEnv.executeSql("CREATE TABLE cat1.db2.tbl1 WITH ('connector' = 'values')");
        tableEnv.executeSql("CREATE VIEW cat1.db2.tbl2 AS SELECT 1");
        tableEnv.executeSql("CREATE DATABASE cat2.db0");
        tableEnv.executeSql("CREATE TABLE cat2.db0.tbl0 WITH('connector' = 'values')");
        return sessionHandle;
    }

    public static ResultSet fetchResults(SqlGatewayService service, SessionHandle sessionHandle, OperationHandle operationHandle) {
        return service.fetchResults(sessionHandle, operationHandle, 0L, Integer.MAX_VALUE);
    }

    public static void awaitOperationTermination(SqlGatewayService service, SessionHandle sessionHandle, OperationHandle operationHandle) throws Exception {
        ((SqlGatewayServiceImpl)service).getSession(sessionHandle).getOperationManager().awaitOperationTermination(operationHandle);
    }
}

