/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.session;

import java.io.File;
import java.time.Duration;
import java.util.Collections;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.gateway.api.config.SqlGatewayServiceConfigOptions;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.MockedEndpointVersion;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.session.Session;
import org.apache.flink.table.gateway.service.session.SessionManagerImpl;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SessionManagerImplTest {
    private SessionManagerImpl sessionManager;

    SessionManagerImplTest() {
    }

    @BeforeEach
    void setup() {
        Configuration conf = new Configuration();
        conf.set(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_IDLE_TIMEOUT, (Object)Duration.ofSeconds(2L));
        conf.set(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_CHECK_INTERVAL, (Object)Duration.ofMillis(100L));
        conf.set(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_MAX_NUM, (Object)3);
        this.sessionManager = new SessionManagerImpl(new DefaultContext(conf, Collections.emptyList()));
        this.sessionManager.start();
    }

    @AfterEach
    void cleanUp() {
        if (this.sessionManager != null) {
            this.sessionManager.stop();
        }
    }

    @Test
    void testIdleSessionCleanup() throws Exception {
        SessionEnvironment environment = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).build();
        Session session = this.sessionManager.openSession(environment);
        SessionHandle sessionId = session.getSessionHandle();
        for (int i = 0; i < 3; ++i) {
            this.sessionManager.getSession(sessionId);
            Thread.sleep(1000L);
        }
        Deadline deadline = Deadline.fromNow((Duration)Duration.ofSeconds(10L));
        while (deadline.hasTimeLeft() && this.sessionManager.isSessionAlive(sessionId)) {
            Thread.sleep(1000L);
        }
        Assertions.assertFalse((boolean)this.sessionManager.isSessionAlive(sessionId));
    }

    @Test
    void testSessionNumberLimit() {
        SessionEnvironment environment = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).build();
        this.sessionManager.openSession(environment);
        this.sessionManager.openSession(environment);
        this.sessionManager.openSession(environment);
        Assertions.assertEquals((int)3, (int)this.sessionManager.currentSessionCount());
        Assertions.assertThrows(SqlGatewayException.class, () -> this.sessionManager.openSession(environment), (String)"Failed to create session, the count of active sessions exceeds the max count: 3");
    }

    @Test
    void testRunWithCatalogStore() {
        Configuration conf = new Configuration();
        conf.set(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_IDLE_TIMEOUT, (Object)Duration.ofSeconds(60000L));
        conf.set(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_CHECK_INTERVAL, (Object)Duration.ofMillis(100L));
        conf.set(CommonCatalogOptions.TABLE_CATALOG_STORE_KIND, (Object)"test-catalog-store");
        conf.set(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_MAX_NUM, (Object)3);
        this.sessionManager = new SessionManagerImpl(new DefaultContext(conf, Collections.emptyList()));
        this.sessionManager.start();
        SessionEnvironment environment = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).build();
        Session session1 = this.sessionManager.openSession(environment);
        Session session2 = this.sessionManager.openSession(environment);
        Configuration configuration = new Configuration();
        configuration.setString("type", "generic_in_memory");
        session1.createExecutor().getTableEnvironment().getCatalogManager().createCatalog("cat1", CatalogDescriptor.of((String)"cat1", (Configuration)configuration));
        session2.createExecutor().getTableEnvironment().getCatalogManager().createCatalog("cat2", CatalogDescriptor.of((String)"cat2", (Configuration)configuration));
        Assertions.assertTrue((boolean)session1.createExecutor().listCatalogs().contains("cat1"));
        Assertions.assertTrue((boolean)session1.createExecutor().listCatalogs().contains("cat2"));
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> session1.createExecutor().getTableEnvironment().createCatalog("cat2", CatalogDescriptor.of((String)"cat2", (Configuration)configuration))).isInstanceOf(CatalogException.class)).hasMessageContaining("Catalog cat2 already exists in catalog store.");
        this.sessionManager.stop();
    }

    @Test
    void testRunWithFileCatalogStore(@TempDir File tempFolder) {
        Configuration conf = new Configuration();
        conf.set(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_IDLE_TIMEOUT, (Object)Duration.ofSeconds(60000L));
        conf.set(CommonCatalogOptions.TABLE_CATALOG_STORE_KIND, (Object)"file");
        conf.setString("table.catalog-store.file.path", tempFolder.getAbsolutePath());
        this.sessionManager = new SessionManagerImpl(new DefaultContext(conf, Collections.emptyList()));
        this.sessionManager.start();
        SessionEnvironment environment = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).build();
        Configuration configuration = new Configuration();
        configuration.setString("type", "generic_in_memory");
        Session session1 = this.sessionManager.openSession(environment);
        session1.createExecutor().getTableEnvironment().getCatalogManager().createCatalog("cat1", CatalogDescriptor.of((String)"cat1", (Configuration)configuration));
        Assertions.assertTrue((boolean)session1.createExecutor().listCatalogs().contains("cat1"));
        Session session2 = this.sessionManager.openSession(environment);
        session2.createExecutor().getTableEnvironment().getCatalogManager().createCatalog("cat2", CatalogDescriptor.of((String)"cat2", (Configuration)configuration));
        Assertions.assertTrue((boolean)session1.createExecutor().listCatalogs().contains("cat1"));
        Assertions.assertTrue((boolean)session1.createExecutor().listCatalogs().contains("cat2"));
        Assertions.assertTrue((boolean)session2.createExecutor().listCatalogs().contains("cat2"));
        Assertions.assertTrue((boolean)session2.createExecutor().listCatalogs().contains("cat1"));
        this.sessionManager.stop();
    }
}

