/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.listener.CatalogListener1;
import org.apache.flink.table.catalog.listener.CatalogListener2;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.MockedEndpointVersion;
import org.apache.flink.table.gateway.api.utils.ThreadUtils;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SessionContextTest {
    private static final ExecutorService EXECUTOR_SERVICE = ThreadUtils.newThreadPool((int)5, (int)500, (long)600000L, (String)"session-context-test");
    private SessionContext sessionContext;

    SessionContextTest() {
    }

    @BeforeEach
    void setup() {
        this.sessionContext = this.createSessionContext();
    }

    @AfterEach
    void cleanUp() {
        this.sessionContext.close();
    }

    @AfterAll
    static void closeResources() {
        EXECUTOR_SERVICE.shutdown();
    }

    @Test
    void testSetAndResetOption() {
        this.sessionContext.set(PipelineOptions.MAX_PARALLELISM.key(), "128");
        this.sessionContext.set(PipelineOptions.NAME.key(), "test");
        this.sessionContext.set(PipelineOptions.OBJECT_REUSE.key(), "false");
        Assertions.assertThat((Integer)((Integer)this.sessionContext.getSessionConf().get(PipelineOptions.MAX_PARALLELISM))).isEqualTo(128);
        Assertions.assertThat((String)((String)this.sessionContext.getSessionConf().get(PipelineOptions.NAME))).isEqualTo("test");
        Assertions.assertThat((Boolean)((Boolean)this.sessionContext.getSessionConf().get(PipelineOptions.OBJECT_REUSE))).isFalse();
        this.sessionContext.reset();
        Assertions.assertThat((String)((String)this.sessionContext.getSessionConf().get(TableConfigOptions.TABLE_SQL_DIALECT))).isEqualTo("default");
        Assertions.assertThat((String)((String)this.sessionContext.getSessionConf().get(PipelineOptions.NAME))).isNull();
        Assertions.assertThat((Integer)((Integer)this.sessionContext.getSessionConf().get(PipelineOptions.MAX_PARALLELISM))).isEqualTo(16);
        Assertions.assertThat((Optional)this.sessionContext.getSessionConf().getOptional(PipelineOptions.NAME)).isEmpty();
        Assertions.assertThat((Boolean)((Boolean)this.sessionContext.getSessionConf().get(PipelineOptions.OBJECT_REUSE))).isTrue();
    }

    @Test
    void testSetAndResetKeyInConfigOptions() {
        this.sessionContext.set(PipelineOptions.MAX_PARALLELISM.key(), "128");
        this.sessionContext.set(PipelineOptions.NAME.key(), "test");
        this.sessionContext.set(PipelineOptions.OBJECT_REUSE.key(), "false");
        Assertions.assertThat((Integer)((Integer)this.sessionContext.getSessionConf().get(PipelineOptions.MAX_PARALLELISM))).isEqualTo(128);
        Assertions.assertThat((String)((String)this.sessionContext.getSessionConf().get(PipelineOptions.NAME))).isEqualTo("test");
        Assertions.assertThat((Boolean)((Boolean)this.sessionContext.getSessionConf().get(PipelineOptions.OBJECT_REUSE))).isFalse();
        this.sessionContext.reset(TableConfigOptions.TABLE_SQL_DIALECT.key());
        Assertions.assertThat((String)((String)this.sessionContext.getSessionConf().get(TableConfigOptions.TABLE_SQL_DIALECT))).isEqualTo("default");
        this.sessionContext.reset(PipelineOptions.MAX_PARALLELISM.key());
        Assertions.assertThat((Integer)((Integer)this.sessionContext.getSessionConf().get(PipelineOptions.MAX_PARALLELISM))).isEqualTo(16);
        this.sessionContext.reset(PipelineOptions.NAME.key());
        Assertions.assertThat((String)((String)this.sessionContext.getSessionConf().get(PipelineOptions.NAME))).isNull();
        this.sessionContext.reset(PipelineOptions.OBJECT_REUSE.key());
        Assertions.assertThat((Boolean)((Boolean)this.sessionContext.getSessionConf().get(PipelineOptions.OBJECT_REUSE))).isTrue();
    }

    @Test
    void testSetAndResetArbitraryKey() {
        this.sessionContext.set("aa", "11");
        this.sessionContext.set("bb", "22");
        ConfigOption aa = ConfigOptions.key((String)"aa").stringType().defaultValue((Object)"11");
        ConfigOption bb = ConfigOptions.key((String)"bb").stringType().defaultValue((Object)"22");
        Assertions.assertThat((Object)this.sessionContext.getSessionConf()).matches(conf -> conf.contains(aa) && conf.contains(bb));
        this.sessionContext.reset("aa");
        Assertions.assertThat((Object)this.sessionContext.getSessionConf()).matches(conf -> !conf.containsKey("aa") && conf.contains(bb));
        this.sessionContext.reset("bb");
        Assertions.assertThat((Object)this.sessionContext.getSessionConf()).matches(conf -> !conf.containsKey("aa") && !conf.containsKey("bb"));
    }

    @Test
    void testCreateContextWithListeners() {
        Assertions.assertThat((boolean)this.sessionContext.getSessionState().catalogManager.getCatalogModificationListeners().isEmpty()).isTrue();
        Configuration flinkConfig = new Configuration();
        SessionContext context1 = SessionContext.create((DefaultContext)new DefaultContext(flinkConfig, Collections.emptyList()), (SessionHandle)SessionHandle.create(), (SessionEnvironment)SessionEnvironment.newBuilder().addSessionConfig(Collections.singletonMap(TableConfigOptions.TABLE_CATALOG_MODIFICATION_LISTENERS.key(), String.format("%s;%s", "factory1", "factory2"))).setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).build(), (ExecutorService)EXECUTOR_SERVICE);
        Assertions.assertThat(context1.getSessionState().catalogManager.getCatalogModificationListeners().stream().map(l -> l.getClass().getName()).collect(Collectors.toList())).isEqualTo(Arrays.asList(CatalogListener1.class.getName(), CatalogListener2.class.getName()));
        flinkConfig.set(TableConfigOptions.TABLE_CATALOG_MODIFICATION_LISTENERS, Arrays.asList("factory1", "factory2"));
        SessionContext context2 = SessionContext.create((DefaultContext)new DefaultContext(flinkConfig, Collections.emptyList()), (SessionHandle)SessionHandle.create(), (SessionEnvironment)SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).build(), (ExecutorService)EXECUTOR_SERVICE);
        Assertions.assertThat(context2.getSessionState().catalogManager.getCatalogModificationListeners().stream().map(l -> l.getClass().getName()).collect(Collectors.toList())).isEqualTo(Arrays.asList(CatalogListener1.class.getName(), CatalogListener2.class.getName()));
    }

    private SessionContext createSessionContext() {
        Configuration flinkConfig = new Configuration();
        flinkConfig.set(PipelineOptions.OBJECT_REUSE, (Object)true);
        flinkConfig.set(PipelineOptions.MAX_PARALLELISM, (Object)16);
        DefaultContext defaultContext = new DefaultContext(flinkConfig, Collections.emptyList());
        SessionEnvironment environment = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).addSessionConfig(flinkConfig.toMap()).build();
        return SessionContext.create((DefaultContext)defaultContext, (SessionHandle)SessionHandle.create(), (SessionEnvironment)environment, (ExecutorService)EXECUTOR_SERVICE);
    }
}

