/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.rest.SqlGatewayRestEndpoint;
import org.apache.flink.util.ConfigurationException;

public class TestingSqlGatewayRestEndpoint
extends SqlGatewayRestEndpoint {
    private final List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers;

    public static Builder builder(Configuration configuration, SqlGatewayService sqlGatewayService) {
        return new Builder(configuration, sqlGatewayService);
    }

    private TestingSqlGatewayRestEndpoint(Configuration configuration, List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers, SqlGatewayService sqlGatewayService) throws IOException, ConfigurationException {
        super(configuration, sqlGatewayService);
        this.handlers = handlers;
    }

    protected List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> ignore) {
        return this.handlers;
    }

    protected void startInternal() {
    }

    public static class Builder {
        private final Configuration configuration;
        private final List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers = new ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>>();
        private final SqlGatewayService sqlGatewayService;

        private Builder(Configuration configuration, SqlGatewayService sqlGatewayService) {
            this.configuration = configuration;
            this.sqlGatewayService = sqlGatewayService;
        }

        public Builder withHandler(RestHandlerSpecification messageHeaders, ChannelInboundHandler handler) {
            this.handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)messageHeaders, (Object)handler));
            return this;
        }

        public TestingSqlGatewayRestEndpoint build() throws IOException, ConfigurationException {
            return new TestingSqlGatewayRestEndpoint(this.configuration, this.handlers, this.sqlGatewayService);
        }

        public TestingSqlGatewayRestEndpoint buildAndStart() throws Exception {
            TestingSqlGatewayRestEndpoint serverEndpoint = this.build();
            serverEndpoint.start();
            return serverEndpoint;
        }
    }
}

