/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;
import org.apache.flink.table.gateway.rest.serde.ResultInfoDeserializer;
import org.apache.flink.table.gateway.rest.serde.ResultInfoSerializer;
import org.apache.flink.table.gateway.rest.util.RowFormat;
import org.apache.flink.table.planner.functions.casting.RowDataToStringConverterImpl;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

class ResultInfoJsonSerDeTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Row testRow = ResultInfoJsonSerDeTest.initRow();

    ResultInfoJsonSerDeTest() {
    }

    @BeforeAll
    static void setUp() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(ResultInfo.class, (JsonSerializer)new ResultInfoSerializer());
        simpleModule.addDeserializer(ResultInfo.class, (JsonDeserializer)new ResultInfoDeserializer());
        OBJECT_MAPPER.registerModule((Module)simpleModule);
    }

    @ParameterizedTest
    @EnumSource(value=RowFormat.class)
    void testResultInfoSerDeWithSingleRow(RowFormat rowFormat) throws Exception {
        this.serDeTest(Collections.singletonList(testRow), rowFormat);
    }

    @ParameterizedTest
    @EnumSource(value=RowFormat.class)
    void testResultInfoSerDeWithMultiRowData(RowFormat rowFormat) throws Exception {
        this.serDeTest(Collections.nCopies(10, testRow), rowFormat);
    }

    @ParameterizedTest
    @EnumSource(value=RowFormat.class)
    void testResultInfoSerDeWithNullValues(RowFormat rowFormat) throws Exception {
        List<Integer> positions = IntStream.range(0, 20).mapToObj(i -> new Random().nextInt(20)).collect(Collectors.toList());
        this.serDeTest(Collections.nCopies(10, this.getTestRowDataWithNullValues(ResultInfoJsonSerDeTest.initRow(), positions)), rowFormat);
    }

    @ParameterizedTest
    @ValueSource(strings={"result_info_json_format.txt", "result_info_plain_text_format.txt"})
    void testDeserializationFromJson(String fileName) throws Exception {
        URL url = ResultInfoJsonSerDeTest.class.getClassLoader().getResource(fileName);
        String input = IOUtils.toString((URL)((URL)Preconditions.checkNotNull((Object)url)), (Charset)StandardCharsets.UTF_8).trim();
        ResultInfo deserializedResult = (ResultInfo)OBJECT_MAPPER.readValue(input, ResultInfo.class);
        Assertions.assertThat((String)OBJECT_MAPPER.writeValueAsString((Object)deserializedResult)).isEqualTo(input);
    }

    private void serDeTest(List<Row> rows, RowFormat rowFormat) throws IOException {
        List rowDatas = rows.stream().map(this::convertToInternal).collect(Collectors.toList());
        if (rowFormat == RowFormat.PLAIN_TEXT) {
            rowDatas = rowDatas.stream().map(this::toPlainTextFormatRowData).collect(Collectors.toList());
        }
        ResolvedSchema testResolvedSchema = this.getTestResolvedSchema(this.getFields());
        ResultInfo testResultInfo = new ResultInfo(testResolvedSchema.getColumns().stream().map(ColumnInfo::toColumnInfo).collect(Collectors.toList()), rowDatas, rowFormat);
        String result = OBJECT_MAPPER.writeValueAsString((Object)testResultInfo);
        ResultInfo resultInfo = (ResultInfo)OBJECT_MAPPER.readValue(result, ResultInfo.class);
        Assertions.assertThat((Object)resultInfo.getResultSchema()).hasToString(testResultInfo.getResultSchema().toString());
        this.assertDataWithFormat(resultInfo.getData(), rows, rowFormat);
    }

    private static Row initRow() {
        int tinyint = 99;
        int smallint = 128;
        int intValue = 45536;
        float floatValue = 33.333f;
        long bigint = 1238123899121L;
        String name = "asdlkjasjkdla998y1122";
        byte[] bytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(bytes);
        Double[] doubles = new Double[]{1.1, 2.2, 3.3};
        BigDecimal decimal = new BigDecimal("123.456789");
        LocalDate date = LocalDate.parse("1990-10-14");
        LocalTime time = LocalTime.parse("12:12:43");
        Timestamp timestamp3 = Timestamp.valueOf("1990-10-14 12:12:43.123");
        Timestamp timestamp9 = Timestamp.valueOf("1990-10-14 12:12:43.123456789");
        long duration = Duration.of(123L, ChronoUnit.HOURS).getSeconds();
        int period = Period.of(1, 2, 3).getDays();
        Instant timestampWithLocalZone = LocalDateTime.of(1990, 10, 14, 12, 12, 43, 123456789).atOffset(ZoneOffset.of("Z")).toInstant();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("element", 123L);
        HashMap<String, Integer> multiSet = new HashMap<String, Integer>();
        multiSet.put("element", 2);
        HashMap nestedMap = new HashMap();
        HashMap<String, Integer> innerMap = new HashMap<String, Integer>();
        innerMap.put("key", 234);
        nestedMap.put("inner_map", innerMap);
        Row testRow = new Row(20);
        ResultInfoJsonSerDeTest.setRandomKind(testRow);
        testRow.setField(0, (Object)true);
        testRow.setField(1, (Object)99);
        testRow.setField(2, (Object)128);
        testRow.setField(3, (Object)45536);
        testRow.setField(4, (Object)1238123899121L);
        testRow.setField(5, (Object)Float.valueOf(33.333f));
        testRow.setField(6, (Object)"asdlkjasjkdla998y1122");
        testRow.setField(7, (Object)bytes);
        testRow.setField(8, (Object)decimal);
        testRow.setField(9, (Object)doubles);
        testRow.setField(10, (Object)date);
        testRow.setField(11, (Object)time);
        testRow.setField(12, (Object)timestamp3.toLocalDateTime());
        testRow.setField(13, (Object)timestamp9.toLocalDateTime());
        testRow.setField(14, (Object)timestampWithLocalZone);
        testRow.setField(15, map);
        testRow.setField(16, multiSet);
        testRow.setField(17, nestedMap);
        testRow.setField(18, (Object)duration);
        testRow.setField(19, (Object)period);
        return testRow;
    }

    private static void setRandomKind(Row testRow) {
        int i = new Random().nextInt() % 4;
        switch (i) {
            case 0: {
                testRow.setKind(RowKind.INSERT);
                break;
            }
            case 1: {
                testRow.setKind(RowKind.DELETE);
                break;
            }
            case 2: {
                testRow.setKind(RowKind.UPDATE_AFTER);
                break;
            }
            case 3: {
                testRow.setKind(RowKind.UPDATE_BEFORE);
            }
        }
    }

    private List<DataTypes.Field> getFields() {
        return Arrays.asList(DataTypes.FIELD((String)"bool", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"tinyint", (DataType)DataTypes.TINYINT()), DataTypes.FIELD((String)"smallint", (DataType)DataTypes.SMALLINT()), DataTypes.FIELD((String)"int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"bigint", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"bytes", (DataType)DataTypes.BYTES()), DataTypes.FIELD((String)"decimal", (DataType)DataTypes.DECIMAL((int)9, (int)6)), DataTypes.FIELD((String)"doubles", (DataType)DataTypes.ARRAY((DataType)DataTypes.DOUBLE())), DataTypes.FIELD((String)"date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"time", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"timestamp3", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"timestamp9", (DataType)DataTypes.TIMESTAMP((int)9)), DataTypes.FIELD((String)"timestampWithLocalZone", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT())), DataTypes.FIELD((String)"multiSet", (DataType)DataTypes.MULTISET((DataType)DataTypes.STRING())), DataTypes.FIELD((String)"map2map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()))), DataTypes.FIELD((String)"dayTimeInterval", (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND((int)3))), DataTypes.FIELD((String)"yearMonthInterval", (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH())));
    }

    private ResolvedSchema getTestResolvedSchema(List<DataTypes.Field> fields) {
        List columnNames = fields.stream().map(DataTypes.AbstractField::getName).collect(Collectors.toList());
        List columnDataTypes = fields.stream().map(DataTypes.Field::getDataType).collect(Collectors.toList());
        return ResolvedSchema.physical(columnNames, columnDataTypes);
    }

    private Row getTestRowDataWithNullValues(Row testRow, List<Integer> positions) {
        for (int position : positions) {
            testRow.setField(position, null);
        }
        return testRow;
    }

    private Row convertToExternal(RowData rowData, DataType dataType) {
        return (Row)DataFormatConverters.getConverterForDataType((DataType)dataType).toExternal((Object)rowData);
    }

    private GenericRowData convertToInternal(Row row) {
        DataFormatConverters.DataFormatConverter converter = DataFormatConverters.getConverterForDataType((DataType)DataTypes.ROW(this.getFields()));
        return (GenericRowData)converter.toInternal((Object)row);
    }

    private RowData toPlainTextFormatRowData(RowData rowData) {
        RowDataToStringConverterImpl converter = new RowDataToStringConverterImpl(this.getTestResolvedSchema(this.getFields()).toPhysicalRowDataType(), DateTimeUtils.UTC_ZONE.toZoneId(), ResultInfoJsonSerDeTest.class.getClassLoader(), false);
        StringData[] plainText = (StringData[])Arrays.stream(converter.convert(rowData)).map(StringData::fromString).toArray(StringData[]::new);
        return GenericRowData.ofKind((RowKind)rowData.getRowKind(), (Object[])plainText);
    }

    private void assertDataWithFormat(List<RowData> expected, List<Row> actual, RowFormat rowFormat) {
        if (rowFormat == RowFormat.JSON) {
            for (int i = 0; i < expected.size(); ++i) {
                Assertions.assertThat((Object)this.convertToExternal(expected.get(i), DataTypes.ROW(this.getFields()))).isEqualTo((Object)actual.get(i));
            }
        } else {
            for (int i = 0; i < expected.size(); ++i) {
                this.assertPlainTextFormatData(expected.get(i), this.toPlainTextFormatRowData((RowData)this.convertToInternal(actual.get(i))));
            }
        }
    }

    private void assertPlainTextFormatData(RowData expected, RowData actual) {
        for (int i = 0; i < expected.getArity(); ++i) {
            Assertions.assertThat((Comparable)expected.getString(i)).isEqualTo((Object)actual.getString(i));
        }
    }
}

