/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.gateway.rest.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.gateway.rest.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DataTypeJsonSerdeTest;
import org.apache.flink.table.runtime.typeutils.ExternalSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
class LogicalTypeJsonSerDeTest {
    private final ObjectMapper mapper = this.buildObjectMapper();

    LogicalTypeJsonSerDeTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"generateTestData"})
    void testLogicalTypeJsonSerDe(LogicalType logicalType) throws IOException {
        String json = this.mapper.writeValueAsString((Object)logicalType);
        LogicalType actualType = (LogicalType)this.mapper.readValue(json, LogicalType.class);
        Assertions.assertThat((Object)actualType).isEqualTo((Object)logicalType);
    }

    @Test
    void testSerializeUnsupportedType() {
        StructuredType unsupportedType = StructuredType.newBuilder(DataTypeJsonSerdeTest.PojoClass.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new IntType(true)), new StructuredType.StructuredAttribute("f1", (LogicalType)new BigIntType(true)), new StructuredType.StructuredAttribute("f2", (LogicalType)new VarCharType(200), "desc"))).build();
        Assertions.assertThatThrownBy(() -> this.lambda$testSerializeUnsupportedType$0((LogicalType)unsupportedType)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)String.format("Unable to serialize logical type '%s'. Please check the documentation for supported types.", unsupportedType.asSummaryString()))});
    }

    @Test
    void testDeserializeUnsupportedType() {
        String unsupportedTypeString = "STRUCTURED_TYPE";
        String json = String.format("{\"%s\": \"%s\", \"%s\": %s}", "type", unsupportedTypeString, "nullable", "true");
        Assertions.assertThatThrownBy(() -> {
            LogicalType cfr_ignored_0 = (LogicalType)this.mapper.readValue(json, LogicalType.class);
        }).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)String.format("Unable to deserialize a logical type of type root '%s'. Please check the documentation for supported types.", unsupportedTypeString))});
    }

    @Test
    void testDeserializeUnsupportedJson() {
        String json = String.format("{\"%s\": \"%s\"}", "unknown", "whatever");
        Assertions.assertThatThrownBy(() -> {
            LogicalType cfr_ignored_0 = (LogicalType)this.mapper.readValue(json, LogicalType.class);
        }).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)"Cannot parse this Json String")});
    }

    private static List<LogicalType> generateTestData() {
        List<LogicalType> types = Arrays.asList(new BooleanType(), new TinyIntType(), new SmallIntType(), new IntType(), new BigIntType(), new FloatType(), new DoubleType(), new DateType(), CharType.ofEmptyLiteral(), new CharType(), new CharType(5), VarCharType.ofEmptyLiteral(), new VarCharType(), new VarCharType(5), BinaryType.ofEmptyLiteral(), new BinaryType(), new BinaryType(100), VarBinaryType.ofEmptyLiteral(), new VarBinaryType(), new VarBinaryType(100), new DecimalType(10), new DecimalType(15, 5), new TimeType(), new TimeType(3), new TimestampType(), new TimestampType(3), new TimestampType(false, 3), new ZonedTimestampType(), new ZonedTimestampType(3), new LocalZonedTimestampType(), new LocalZonedTimestampType(3), new LocalZonedTimestampType(false, 3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new MapType((LogicalType)new BigIntType(), (LogicalType)new IntType(false)), new MapType((LogicalType)CharType.ofEmptyLiteral(), (LogicalType)CharType.ofEmptyLiteral()), new MapType((LogicalType)VarCharType.ofEmptyLiteral(), (LogicalType)VarCharType.ofEmptyLiteral()), new MapType((LogicalType)BinaryType.ofEmptyLiteral(), (LogicalType)BinaryType.ofEmptyLiteral()), new MapType((LogicalType)VarBinaryType.ofEmptyLiteral(), (LogicalType)VarBinaryType.ofEmptyLiteral()), new MapType((LogicalType)new TimestampType(false, 3), (LogicalType)new LocalZonedTimestampType()), new ArrayType((LogicalType)new IntType(false)), new ArrayType((LogicalType)new TimestampType()), new ArrayType((LogicalType)new LocalZonedTimestampType(false, 3)), new ArrayType((LogicalType)CharType.ofEmptyLiteral()), new ArrayType((LogicalType)VarCharType.ofEmptyLiteral()), new ArrayType((LogicalType)BinaryType.ofEmptyLiteral()), new ArrayType((LogicalType)VarBinaryType.ofEmptyLiteral()), new MultisetType((LogicalType)new IntType(false)), new MultisetType((LogicalType)new TimestampType()), new MultisetType((LogicalType)new TimestampType(true, 3)), new MultisetType((LogicalType)CharType.ofEmptyLiteral()), new MultisetType((LogicalType)VarCharType.ofEmptyLiteral()), new MultisetType((LogicalType)BinaryType.ofEmptyLiteral()), new MultisetType((LogicalType)VarBinaryType.ofEmptyLiteral()), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(false), new VarCharType(200)}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(false), new VarCharType(200)}, (String[])new String[]{"f1", "f2", "f3"}), RowType.of((LogicalType[])new LogicalType[]{new TimestampType(false, 3), new LocalZonedTimestampType(false, 3)}), RowType.of((LogicalType[])new LogicalType[]{CharType.ofEmptyLiteral(), VarCharType.ofEmptyLiteral(), BinaryType.ofEmptyLiteral(), VarBinaryType.ofEmptyLiteral()}), new RowType(Arrays.asList(new RowType.RowField("ID", (LogicalType)new BigIntType(), "ID desc"), new RowType.RowField("Name", (LogicalType)new VarCharType(20), "Name desc"))), new RawType(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE), new RawType(Row.class, (TypeSerializer)ExternalSerializer.of((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()}))), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_MINUTE), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_MINUTE), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_SECOND), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE_TO_SECOND), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.SECOND));
        List<LogicalType> testTypes = Stream.concat(types.stream().map(type -> type.copy(true)), types.stream().map(type -> type.copy(false))).collect(Collectors.toList());
        testTypes.add((LogicalType)new NullType());
        return testTypes;
    }

    private ObjectMapper buildObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new LogicalTypeJsonSerializer());
        module.addDeserializer(LogicalType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    private /* synthetic */ void lambda$testSerializeUnsupportedType$0(LogicalType unsupportedType) throws Throwable {
        this.mapper.writeValueAsString((Object)unsupportedType);
    }

    public static class PojoClass {
        public int f0;
        public long f1;
        public String f2;
    }
}

