/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.table.gateway.SqlGateway;
import org.apache.flink.table.gateway.api.utils.MockedSqlGatewayEndpoint;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SqlGatewayTest {
    private Map<String, String> originalEnv;
    private ByteArrayOutputStream output;

    SqlGatewayTest() {
    }

    @BeforeEach
    void before(@TempDir File tempFolder) throws IOException {
        this.originalEnv = System.getenv();
        File confYaml = new File(tempFolder, "flink-conf.yaml");
        if (!confYaml.createNewFile()) {
            throw new IOException("Can't create testing flink-conf.yaml file.");
        }
        HashMap<String, String> map = new HashMap<String, String>(System.getenv());
        map.put("FLINK_CONF_DIR", tempFolder.getAbsolutePath());
        CommonTestUtils.setEnv(map);
        this.output = new ByteArrayOutputStream(256);
    }

    @AfterEach
    void cleanup() throws Exception {
        CommonTestUtils.setEnv(this.originalEnv);
        if (this.output != null) {
            this.output.close();
        }
    }

    @Test
    void testPrintStartGatewayHelp() {
        String[] args = new String[]{"--help"};
        SqlGateway.startSqlGateway((PrintStream)new PrintStream(this.output), (String[])args);
        AssertionsForClassTypes.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Start the Flink SQL Gateway as a daemon to submit Flink SQL.\n\n  Syntax: start [OPTIONS]\n     -D <property=value>   Use value for given property\n     -h,--help             Show the help message with descriptions of all\n                           options.\n\n"});
    }

    @Test
    void testConfigureSqlGateway() throws Exception {
        String id = UUID.randomUUID().toString();
        String[] args = new String[]{"-Dsql-gateway.endpoint.type=mocked", "-Dsql-gateway.endpoint.mocked.id=" + id, "-Dsql-gateway.endpoint.mocked.host=localhost", "-Dsql-gateway.endpoint.mocked.port=9999"};
        try (PrintStream stream = new PrintStream(this.output);){
            Thread thread = new ExecutorThreadFactory("SqlGateway-thread-pool", (t, exception) -> exception.printStackTrace(stream)).newThread(() -> SqlGateway.startSqlGateway((PrintStream)stream, (String[])args));
            thread.start();
            CommonTestUtils.waitUtil(() -> MockedSqlGatewayEndpoint.isRunning((String)id), (Duration)Duration.ofSeconds(10L), (String)"Failed to get the endpoint starts.");
            thread.interrupt();
            CommonTestUtils.waitUtil(() -> !thread.isAlive(), (Duration)Duration.ofSeconds(10L), (String)"Failed to get the endpoint starts.");
            AssertionsForClassTypes.assertThat((String)this.output.toString()).doesNotContain(new CharSequence[]{"Unexpected exception. This is a bug. Please consider filing an issue."});
        }
    }

    @Test
    void testFailedToStartSqlGateway() {
        try (PrintStream stream = new PrintStream(this.output);){
            AssertionsForClassTypes.assertThatThrownBy(() -> SqlGateway.startSqlGateway((PrintStream)stream, (String[])new String[0])).doesNotHaveToString("Unexpected exception. This is a bug. Please consider filing an issue.");
        }
    }
}

