/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.FetchOrientation;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.service.result.ResultStore;
import org.apache.flink.table.gateway.service.utils.SqlExecutionException;
import org.apache.flink.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(ResultFetcher.class);
    private static final int TABLE_RESULT_MAX_INITIAL_CAPACITY = 5000;
    private final OperationHandle operationHandle;
    private final ResolvedSchema resultSchema;
    private final ResultStore resultStore;
    private final LinkedList<RowData> bufferedResults = new LinkedList();
    private final LinkedList<RowData> bufferedPrevResults = new LinkedList();
    private long currentToken = 0L;
    private boolean noMoreResults = false;

    public ResultFetcher(OperationHandle operationHandle, ResolvedSchema resultSchema, CloseableIterator<RowData> resultRows) {
        this(operationHandle, resultSchema, resultRows, 5000);
    }

    @VisibleForTesting
    ResultFetcher(OperationHandle operationHandle, ResolvedSchema resultSchema, CloseableIterator<RowData> resultRows, int maxBufferSize) {
        this.operationHandle = operationHandle;
        this.resultSchema = resultSchema;
        this.resultStore = new ResultStore(resultRows, maxBufferSize);
    }

    public ResultFetcher(OperationHandle operationHandle, ResolvedSchema resultSchema, List<RowData> rows) {
        this.operationHandle = operationHandle;
        this.resultSchema = resultSchema;
        this.bufferedResults.addAll(rows);
        this.resultStore = ResultStore.DUMMY_RESULT_STORE;
    }

    public void close() {
        this.resultStore.close();
    }

    public ResolvedSchema getResultSchema() {
        return this.resultSchema;
    }

    public synchronized ResultSet fetchResults(FetchOrientation orientation, int maxFetchSize) {
        long token;
        switch (orientation) {
            case FETCH_NEXT: {
                token = this.currentToken;
                break;
            }
            case FETCH_PRIOR: {
                token = this.currentToken - 1L;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown fetch orientation: %s.", new Object[]{orientation}));
            }
        }
        if (orientation == FetchOrientation.FETCH_NEXT && this.bufferedResults.isEmpty()) {
            this.resultStore.waitUntilHasData();
        }
        return this.fetchResults(token, maxFetchSize);
    }

    public synchronized ResultSet fetchResults(long token, int maxFetchSize) {
        if (maxFetchSize <= 0) {
            throw new IllegalArgumentException("The max rows should be larger than 0.");
        }
        if (token == this.currentToken) {
            if (this.noMoreResults) {
                LOG.debug("There is no more result for operation: {}.", (Object)this.operationHandle);
                return new ResultSet(ResultSet.ResultType.EOS, null, this.resultSchema, Collections.emptyList());
            }
            this.bufferedPrevResults.clear();
            if (this.bufferedResults.isEmpty()) {
                Optional<List<RowData>> newResults = this.resultStore.retrieveRecords();
                if (newResults.isPresent()) {
                    this.bufferedResults.addAll((Collection<RowData>)newResults.get());
                } else {
                    this.noMoreResults = true;
                    return new ResultSet(ResultSet.ResultType.EOS, null, this.resultSchema, Collections.emptyList());
                }
            }
            int resultSize = Math.min(this.bufferedResults.size(), maxFetchSize);
            LOG.debug("Fetching current result for operation: {}, token: {}, maxFetchSize: {}, resultSize: {}.", new Object[]{this.operationHandle, token, maxFetchSize, resultSize});
            ++this.currentToken;
            for (int i = 0; i < resultSize; ++i) {
                this.bufferedPrevResults.add(this.bufferedResults.removeFirst());
            }
            return new ResultSet(ResultSet.ResultType.PAYLOAD, this.currentToken, this.resultSchema, new ArrayList<RowData>(this.bufferedPrevResults));
        }
        if (token == this.currentToken - 1L && token >= 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching previous result for operation: {}, token: {}, maxFetchSize: {}", new Object[]{this.operationHandle, token, maxFetchSize});
            }
            if (maxFetchSize < this.bufferedPrevResults.size()) {
                String msg = String.format("As the same token is provided, fetch size must be not less than the previous returned buffer size. Previous returned result size is %s, current max_fetch_size to be %s.", this.bufferedPrevResults.size(), maxFetchSize);
                if (LOG.isDebugEnabled()) {
                    LOG.error(msg);
                }
                throw new SqlExecutionException(msg);
            }
            return new ResultSet(ResultSet.ResultType.PAYLOAD, this.currentToken, this.resultSchema, new ArrayList<RowData>(this.bufferedPrevResults));
        }
        String msg = this.currentToken == 0L ? "Expecting token to be 0, but found " + token + "." : "Expecting token to be " + this.currentToken + " or " + (this.currentToken - 1L) + ", but found " + token + ".";
        if (LOG.isDebugEnabled()) {
            LOG.error(msg);
        }
        throw new SqlExecutionException(msg);
    }

    @VisibleForTesting
    public ResultStore getResultStore() {
        return this.resultStore;
    }
}

