/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.RowDataToJsonConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.gateway.rest.serde.RowDataInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;

@Internal
public class JsonResultSetSerializer
extends StdSerializer<ResultSet> {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final RowDataToJsonConverters TO_JSON_CONVERTERS = new RowDataToJsonConverters(TimestampFormat.ISO_8601, JsonFormatOptions.MapNullKeyMode.LITERAL, "null");

    public JsonResultSetSerializer() {
        super(ResultSet.class);
    }

    public void serialize(ResultSet resultSet, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        List columns = resultSet.getResultSchema().getColumns();
        ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();
        for (Column column : columns) {
            columnInfos.add(new ColumnInfo(column.getName(), column.getDataType().getLogicalType(), column.getComment().orElse(null)));
        }
        serializerProvider.defaultSerializeField("columns", columnInfos, jsonGenerator);
        ArrayList<RowData.FieldGetter> fieldGetters = new ArrayList<RowData.FieldGetter>();
        for (int i = 0; i < resultSet.getResultSchema().getColumnCount(); ++i) {
            fieldGetters.add(RowData.createFieldGetter((LogicalType)((DataType)resultSet.getResultSchema().getColumnDataTypes().get(i)).getLogicalType(), (int)i));
        }
        List fieldTypes = resultSet.getResultSchema().getColumnDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList());
        List converters = fieldTypes.stream().map(arg_0 -> ((RowDataToJsonConverters)TO_JSON_CONVERTERS).createConverter(arg_0)).collect(Collectors.toList());
        ArrayList<RowDataInfo> data = new ArrayList<RowDataInfo>();
        for (RowData row : resultSet.getData()) {
            RowKind rowKind = row.getRowKind();
            ArrayList<JsonNode> fields = new ArrayList<JsonNode>();
            for (int i = 0; i < row.getArity(); ++i) {
                Object field = ((RowData.FieldGetter)fieldGetters.get(i)).getFieldOrNull(row);
                RowDataToJsonConverters.RowDataToJsonConverter converter = (RowDataToJsonConverters.RowDataToJsonConverter)converters.get(i);
                fields.add(JsonResultSetSerializer.buildJsonValueConverter(converter).apply(field));
            }
            data.add(new RowDataInfo(rowKind.name(), fields));
        }
        serializerProvider.defaultSerializeField("data", data, jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private static Function<Object, JsonNode> buildJsonValueConverter(RowDataToJsonConverters.RowDataToJsonConverter converter) {
        return field -> converter.convert(OBJECT_MAPPER, null, field);
    }
}

