/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.FetchOrientation;
import org.apache.flink.table.gateway.api.results.FunctionInfo;
import org.apache.flink.table.gateway.api.results.GatewayInfo;
import org.apache.flink.table.gateway.api.results.OperationInfo;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.results.TableInfo;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;

@PublicEvolving
public interface SqlGatewayService {
    public SessionHandle openSession(SessionEnvironment var1) throws SqlGatewayException;

    public void closeSession(SessionHandle var1) throws SqlGatewayException;

    public Map<String, String> getSessionConfig(SessionHandle var1) throws SqlGatewayException;

    public EndpointVersion getSessionEndpointVersion(SessionHandle var1) throws SqlGatewayException;

    public OperationHandle submitOperation(SessionHandle var1, Callable<ResultSet> var2) throws SqlGatewayException;

    public void cancelOperation(SessionHandle var1, OperationHandle var2) throws SqlGatewayException;

    public void closeOperation(SessionHandle var1, OperationHandle var2) throws SqlGatewayException;

    public OperationInfo getOperationInfo(SessionHandle var1, OperationHandle var2) throws SqlGatewayException;

    public ResolvedSchema getOperationResultSchema(SessionHandle var1, OperationHandle var2) throws SqlGatewayException;

    public OperationHandle executeStatement(SessionHandle var1, String var2, long var3, Configuration var5) throws SqlGatewayException;

    public ResultSet fetchResults(SessionHandle var1, OperationHandle var2, long var3, int var5) throws SqlGatewayException;

    public ResultSet fetchResults(SessionHandle var1, OperationHandle var2, FetchOrientation var3, int var4) throws SqlGatewayException;

    public String getCurrentCatalog(SessionHandle var1) throws SqlGatewayException;

    public Set<String> listCatalogs(SessionHandle var1) throws SqlGatewayException;

    public Set<String> listDatabases(SessionHandle var1, String var2) throws SqlGatewayException;

    public Set<TableInfo> listTables(SessionHandle var1, String var2, String var3, Set<CatalogBaseTable.TableKind> var4) throws SqlGatewayException;

    public ResolvedCatalogBaseTable<?> getTable(SessionHandle var1, ObjectIdentifier var2) throws SqlGatewayException;

    public Set<FunctionInfo> listUserDefinedFunctions(SessionHandle var1, String var2, String var3) throws SqlGatewayException;

    public Set<FunctionInfo> listSystemFunctions(SessionHandle var1) throws SqlGatewayException;

    public FunctionDefinition getFunctionDefinition(SessionHandle var1, UnresolvedIdentifier var2) throws SqlGatewayException;

    public GatewayInfo getGatewayInfo();
}

