/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import com.pingcap.tidb.tipb.ExprType;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.TypeException;
import org.tikv.common.exception.UnsupportedTypeException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.Converter;
import org.tikv.common.types.DataType;
import org.tikv.common.types.MySQLType;

public class EnumType
extends DataType {
    public static final EnumType ENUM = new EnumType(MySQLType.TypeEnum);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeEnum};

    private EnumType(MySQLType tp) {
        super(tp);
    }

    protected EnumType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return this.convertToMysqlEnum(value);
    }

    private Integer convertToMysqlEnum(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        Integer result;
        if (value instanceof String) {
            result = Codec.EnumCodec.parseEnumName((String)value, this.getElems());
        } else {
            Long l = Converter.safeConvertToUnsigned(value, this.unsignedUpperBound());
            result = Codec.EnumCodec.parseEnumValue(l.intValue(), this.getElems());
        }
        return result;
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        int idx;
        switch (flag) {
            case 4: {
                idx = (int)Codec.IntegerCodec.readULong(cdi) - 1;
                break;
            }
            case 9: {
                idx = (int)Codec.IntegerCodec.readUVarLong(cdi) - 1;
                break;
            }
            default: {
                throw new TypeException("Invalid EnumType(IntegerType) flag: " + flag);
            }
        }
        return Codec.EnumCodec.readEnumFromIndex(idx, this.getElems());
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        long longVal = Converter.convertToLong(value);
        Codec.IntegerCodec.writeULongFully(cdo, longVal, true);
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        long longVal = Converter.convertToLong(value);
        Codec.IntegerCodec.writeULongFully(cdo, longVal, false);
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        throw new UnsupportedTypeException("Enum type cannot be pushed down.");
    }

    @Override
    public String getName() {
        return "ENUM";
    }

    @Override
    public ExprType getProtoExprType() {
        return ExprType.MysqlEnum;
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        return value;
    }

    @Override
    public boolean isPushDownSupported() {
        return false;
    }
}

