/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import com.pingcap.tidb.tipb.ExprType;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.columnar.TiChunkColumnVector;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.TypeException;
import org.tikv.common.meta.Collation;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.Converter;
import org.tikv.common.types.MySQLType;
import org.tikv.shade.com.google.common.collect.ImmutableList;

public abstract class DataType
implements Serializable {
    public static final int NotNullFlag = 1;
    public static final int PriKeyFlag = 2;
    public static final int UniqueKeyFlag = 4;
    public static final int MultipleKeyFlag = 8;
    public static final int BlobFlag = 16;
    public static final int UnsignedFlag = 32;
    public static final int ZerofillFlag = 64;
    public static final int BinaryFlag = 128;
    public static final int EnumFlag = 256;
    public static final int AutoIncrementFlag = 512;
    public static final int TimestampFlag = 1024;
    public static final int SetFlag = 2048;
    public static final int NoDefaultValueFlag = 4096;
    public static final int OnUpdateNowFlag = 8192;
    public static final int NumFlag = 32768;
    public static final long COLUMN_VERSION_FLAG = 1L;
    public static final int UNSPECIFIED_LEN = -1;
    private static final Long MaxInt8 = 127L;
    private static final Long MinInt8 = -128L;
    private static final Long MaxInt16 = 32767L;
    private static final Long MinInt16 = -32768L;
    private static final Long MaxInt24 = 0x7FFFFFL;
    private static final Long MinInt24 = -8388608L;
    private static final Long MaxInt32 = Integer.MAX_VALUE;
    private static final Long MinInt32 = Integer.MIN_VALUE;
    private static final Long MaxInt64 = Long.MAX_VALUE;
    private static final Long MinInt64 = Long.MIN_VALUE;
    private static final Long MaxUint8 = 255L;
    private static final Long MaxUint16 = 65535L;
    private static final Long MaxUint24 = 0xFFFFFFL;
    private static final Long MaxUint32 = 0xFFFFFFFFL;
    private static final Long MaxUint64 = -1L;
    protected final MySQLType tp;
    protected final int flag;
    protected final int decimal;
    protected final int collation;
    protected final long length;
    private final String charset;
    private final List<String> elems;
    private final byte[] allNotNullBitMap = this.initAllNotNullBitMap();
    private final byte[] readBuffer = new byte[8];

    public DataType(MySQLType tp, int prec, int scale) {
        this.tp = tp;
        this.flag = 0;
        this.elems = ImmutableList.of();
        this.length = prec;
        this.decimal = scale;
        this.charset = "";
        this.collation = 83;
    }

    protected DataType(TiColumnInfo.InternalTypeHolder holder) {
        this.tp = MySQLType.fromTypeCode(holder.getTp());
        this.flag = holder.getFlag();
        this.length = holder.getFlen();
        this.decimal = holder.getDecimal();
        this.charset = holder.getCharset();
        this.collation = Collation.translate(holder.getCollate());
        this.elems = holder.getElems() == null ? ImmutableList.of() : holder.getElems();
    }

    protected DataType(MySQLType type) {
        this.tp = type;
        this.flag = 0;
        this.elems = ImmutableList.of();
        this.length = -1L;
        this.decimal = -1;
        this.charset = "";
        this.collation = 83;
    }

    protected DataType(MySQLType type, int flag, int len, int decimal, String charset, int collation) {
        this.tp = type;
        this.flag = flag;
        this.elems = ImmutableList.of();
        this.length = len;
        this.decimal = decimal;
        this.charset = charset;
        this.collation = collation;
    }

    public static void encodeMaxValue(CodecDataOutput cdo) {
        cdo.writeByte(250);
    }

    public static void encodeNull(CodecDataOutput cdo) {
        cdo.writeByte(0);
    }

    public static void encodeIndex(CodecDataOutput cdo) {
        cdo.writeByte(1);
    }

    public static boolean isLengthUnSpecified(long length) {
        return length == -1L;
    }

    public Long signedLowerBound() throws TypeException {
        switch (this.getType()) {
            case TypeTiny: {
                return MinInt8;
            }
            case TypeShort: {
                return MinInt16;
            }
            case TypeInt24: {
                return MinInt24;
            }
            case TypeLong: {
                return MinInt32;
            }
            case TypeLonglong: {
                return MinInt64;
            }
        }
        throw new TypeException("Signed Lower Bound: Input Type is not a mysql SIGNED type");
    }

    public Long signedUpperBound() throws TypeException {
        switch (this.getType()) {
            case TypeTiny: {
                return MaxInt8;
            }
            case TypeShort: {
                return MaxInt16;
            }
            case TypeInt24: {
                return MaxInt24;
            }
            case TypeLong: {
                return MaxInt32;
            }
            case TypeLonglong: {
                return MaxInt64;
            }
        }
        throw new TypeException("Signed Upper Bound: Input Type is not a mysql SIGNED type");
    }

    public Long unsignedUpperBound() throws TypeException {
        switch (this.getType()) {
            case TypeTiny: {
                return MaxUint8;
            }
            case TypeShort: {
                return MaxUint16;
            }
            case TypeInt24: {
                return MaxUint24;
            }
            case TypeLong: {
                return MaxUint32;
            }
            case TypeLonglong: 
            case TypeBit: 
            case TypeEnum: 
            case TypeSet: {
                return MaxUint64;
            }
        }
        throw new TypeException("Unsigned Upper Bound: Input Type is not a mysql UNSIGNED type");
    }

    protected abstract Object decodeNotNull(int var1, CodecDataInput var2);

    protected Object decodeNotNullForBatchWrite(int flag, CodecDataInput cdi) {
        return this.decodeNotNull(flag, cdi);
    }

    private int getFixLen() {
        switch (this.getType()) {
            case TypeFloat: {
                return 4;
            }
            case TypeTiny: 
            case TypeShort: 
            case TypeInt24: 
            case TypeLong: 
            case TypeLonglong: 
            case TypeDouble: 
            case TypeYear: 
            case TypeDuration: 
            case TypeTimestamp: 
            case TypeDate: 
            case TypeDatetime: {
                return 8;
            }
            case TypeDecimal: {
                throw new UnsupportedOperationException("this should not get involved in calculation process");
            }
            case TypeNewDecimal: {
                return 40;
            }
        }
        return -1;
    }

    private byte[] setAllNotNull(int numNullBitMapBytes) {
        int numAppendBytes;
        byte[] nullBitMaps = new byte[numNullBitMapBytes];
        for (int i = 0; i < numNullBitMapBytes; i += numAppendBytes) {
            numAppendBytes = Math.min(numNullBitMapBytes - i, 128);
            if (numAppendBytes < 0) continue;
            System.arraycopy(this.allNotNullBitMap, 0, nullBitMaps, i, numAppendBytes);
        }
        return nullBitMaps;
    }

    private byte[] initAllNotNullBitMap() {
        byte[] allNotNullBitMap = new byte[128];
        Arrays.fill(allNotNullBitMap, (byte)-1);
        return allNotNullBitMap;
    }

    private int readIntLittleEndian(CodecDataInput cdi) {
        int ch1 = cdi.readUnsignedByte();
        int ch2 = cdi.readUnsignedByte();
        int ch3 = cdi.readUnsignedByte();
        int ch4 = cdi.readUnsignedByte();
        return ch1 + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    private long readLongLittleEndian(CodecDataInput cdi) {
        cdi.readFully(this.readBuffer, 0, 8);
        return (long)((this.readBuffer[0] & 0xFF) + ((this.readBuffer[1] & 0xFF) << 8) + ((this.readBuffer[2] & 0xFF) << 16) + ((this.readBuffer[3] & 0xFF) << 24)) + ((long)(this.readBuffer[4] & 0xFF) << 32) + ((long)(this.readBuffer[5] & 0xFF) << 40) + ((long)(this.readBuffer[6] & 0xFF) << 48) + ((long)(this.readBuffer[7] & 0xFF) << 56);
    }

    public boolean isSameCatalog(DataType other) {
        return false;
    }

    public TiChunkColumnVector decodeChunkColumn(CodecDataInput cdi) {
        int numRows = this.readIntLittleEndian(cdi);
        int numNulls = this.readIntLittleEndian(cdi);
        assert (numRows >= 0 && numNulls >= 0);
        int numNullBitmapBytes = (numRows + 7) / 8;
        byte[] nullBitMaps = new byte[numNullBitmapBytes];
        if (numNulls > 0) {
            cdi.readFully(nullBitMaps);
        } else {
            nullBitMaps = this.setAllNotNull(numNullBitmapBytes);
        }
        int numFixedBytes = this.getFixLen();
        int numDataBytes = numFixedBytes * numRows;
        long[] offsets = null;
        if (numFixedBytes == -1) {
            int numOffsets = numRows + 1;
            offsets = new long[numOffsets];
            for (int i = 0; i < numOffsets; ++i) {
                offsets[i] = this.readLongLittleEndian(cdi);
            }
            numDataBytes = (int)offsets[numRows];
        }
        byte[] dataBuffer = new byte[numDataBytes];
        cdi.readFully(dataBuffer);
        ByteBuffer buffer = ByteBuffer.wrap(dataBuffer);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new TiChunkColumnVector(this, numFixedBytes, numRows, numNulls, nullBitMaps, offsets, buffer);
    }

    public Object decode(CodecDataInput cdi) {
        int flag = cdi.readUnsignedByte();
        if (Codec.isNullFlag(flag)) {
            return null;
        }
        return this.decodeNotNull(flag, cdi);
    }

    public Object decodeForBatchWrite(CodecDataInput cdi) {
        int flag = cdi.readUnsignedByte();
        if (Codec.isNullFlag(flag)) {
            return null;
        }
        return this.decodeNotNullForBatchWrite(flag, cdi);
    }

    public boolean isNextNull(CodecDataInput cdi) {
        return Codec.isNullFlag(cdi.peekByte());
    }

    public void encode(CodecDataOutput cdo, EncodeType encodeType, Object value) {
        Objects.requireNonNull(cdo, "cdo is null");
        if (value == null) {
            if (encodeType != EncodeType.PROTO) {
                DataType.encodeNull(cdo);
            }
        } else {
            switch (encodeType) {
                case KEY: {
                    this.encodeKey(cdo, value);
                    return;
                }
                case VALUE: {
                    this.encodeValue(cdo, value);
                    return;
                }
                case PROTO: {
                    this.encodeProto(cdo, value);
                    return;
                }
            }
            throw new TypeException("Unknown encoding type " + (Object)((Object)encodeType));
        }
    }

    public Object convertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        if (value == null) {
            return null;
        }
        return this.doConvertToTiDBType(value);
    }

    protected abstract Object doConvertToTiDBType(Object var1) throws ConvertNotSupportException, ConvertOverflowException;

    protected abstract void encodeKey(CodecDataOutput var1, Object var2);

    protected abstract void encodeValue(CodecDataOutput var1, Object var2);

    protected abstract void encodeProto(CodecDataOutput var1, Object var2);

    public abstract String getName();

    public void encodeKey(CodecDataOutput cdo, Object value, int prefixLength) {
        Objects.requireNonNull(cdo, "cdo is null");
        if (value == null) {
            DataType.encodeNull(cdo);
        } else if (DataType.isLengthUnSpecified(prefixLength)) {
            this.encodeKey(cdo, value);
        } else if (this.isPrefixIndexSupported()) {
            byte[] bytes = this.getCharset().equalsIgnoreCase("utf8") || this.getCharset().equalsIgnoreCase("utf8mb4") ? Converter.convertUtf8ToBytes(value, prefixLength) : Converter.convertToBytes(value, prefixLength);
            Codec.BytesCodec.writeBytesFully(cdo, bytes);
        } else {
            throw new TypeException("Data type can not encode with prefix");
        }
    }

    protected boolean isPrefixIndexSupported() {
        return false;
    }

    public abstract ExprType getProtoExprType();

    public abstract Object getOriginDefaultValueNonNull(String var1, long var2);

    public boolean isPushDownSupported() {
        return true;
    }

    public Object getOriginDefaultValue(String value, long version) {
        if (value == null) {
            return null;
        }
        return this.getOriginDefaultValueNonNull(value, version);
    }

    public int getCollationCode() {
        return this.collation;
    }

    public long getLength() {
        return this.length;
    }

    long getDefaultDataSize() {
        return this.tp.getDefaultSize();
    }

    long getPrefixSize() {
        return this.tp.getPrefixSize();
    }

    public int getDefaultLength() {
        return this.tp.getDefaultLength();
    }

    public long getSize() {
        return this.getPrefixSize() + this.getDefaultDataSize();
    }

    public boolean isLengthUnSpecified() {
        return DataType.isLengthUnSpecified(this.length);
    }

    public boolean isDecimalUnSpecified() {
        return DataType.isLengthUnSpecified(this.decimal);
    }

    public int getDecimal() {
        return this.decimal;
    }

    public int getFlag() {
        return this.flag;
    }

    public List<String> getElems() {
        return this.elems;
    }

    public int getTypeCode() {
        return this.tp.getTypeCode();
    }

    public MySQLType getType() {
        return this.tp;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isPrimaryKey() {
        return (this.flag & 2) > 0;
    }

    public boolean isNotNull() {
        return (this.flag & 1) > 0;
    }

    public boolean isNoDefault() {
        return (this.flag & 0x1000) > 0;
    }

    public boolean isAutoIncrement() {
        return (this.flag & 0x200) > 0;
    }

    public boolean isZeroFill() {
        return (this.flag & 0x40) > 0;
    }

    public boolean isBinary() {
        return (this.flag & 0x80) > 0;
    }

    public boolean isUniqueKey() {
        return (this.flag & 4) > 0;
    }

    public boolean isMultiKey() {
        return (this.flag & 8) > 0;
    }

    public boolean isTimestamp() {
        return (this.flag & 0x400) > 0;
    }

    public boolean isOnUpdateNow() {
        return (this.flag & 0x2000) > 0;
    }

    public boolean isBlob() {
        return (this.flag & 0x10) > 0;
    }

    public boolean isEnum() {
        return (this.flag & 0x100) > 0;
    }

    public boolean isSet() {
        return (this.flag & 0x800) > 0;
    }

    public boolean isNum() {
        return (this.flag & 0x8000) > 0;
    }

    public boolean isUnsigned() {
        return (this.flag & 0x20) > 0;
    }

    public String toString() {
        return String.format("%s:%s", new Object[]{this.getClass().getSimpleName(), this.getType()});
    }

    public boolean equals(Object other) {
        if (other instanceof DataType) {
            DataType otherType = (DataType)other;
            return this.tp == otherType.tp && this.flag == otherType.flag && this.decimal == otherType.decimal && this.charset != null && this.charset.equals(otherType.charset) && this.collation == otherType.collation && this.length == otherType.length && this.elems.equals(otherType.elems);
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)(31 * (this.tp.getTypeCode() == 0 ? 1 : this.tp.getTypeCode()) * (this.flag == 0 ? 1 : this.flag) * (this.decimal == 0 ? 1 : this.decimal) * (this.charset == null ? 1 : this.charset.hashCode()) * (this.collation == 0 ? 1 : this.collation)) * (this.length == 0L ? 1L : this.length) * (long)this.elems.hashCode());
    }

    public TiColumnInfo.InternalTypeHolder toTypeHolder() {
        return new TiColumnInfo.InternalTypeHolder(this.getTypeCode(), this.flag, this.length, this.decimal, this.charset, Collation.translate(this.collation), this.elems);
    }

    public static enum EncodeType {
        KEY,
        VALUE,
        PROTO;

    }
}

