/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.streaming;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.tikv.kvproto.Coprocessor;
import org.tikv.kvproto.Errorpb;

public class StreamingResponse
implements Iterable {
    private final Iterator<Coprocessor.Response> resultIterator;
    private final List<Coprocessor.Response> responseList;

    public StreamingResponse(Iterator resultIterator) {
        Objects.requireNonNull(resultIterator, "Streaming result cannot be null!");
        this.resultIterator = resultIterator;
        this.responseList = new ArrayList<Coprocessor.Response>();
        this.fetchStreamingResult();
    }

    private void fetchStreamingResult() {
        while (this.resultIterator.hasNext()) {
            this.responseList.add(this.resultIterator.next());
        }
    }

    public boolean hasRegionError() {
        for (Coprocessor.Response response : this.responseList) {
            if (!response.hasRegionError()) continue;
            return true;
        }
        return false;
    }

    public Errorpb.Error getFirstRegionError() {
        for (Coprocessor.Response response : this.responseList) {
            if (!response.hasRegionError()) continue;
            return response.getRegionError();
        }
        return null;
    }

    public String getFirstOtherError() {
        for (Coprocessor.Response response : this.responseList) {
            if (response.getOtherError().isEmpty()) continue;
            return response.getOtherError();
        }
        return null;
    }

    @Nonnull
    public Iterator<Coprocessor.Response> iterator() {
        return this.responseList.iterator();
    }
}

