/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tikv.common.expression.ComparisonBinaryExpression;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.LogicalBinaryExpression;
import org.tikv.common.expression.RangeColumnPartitionPruner;
import org.tikv.common.expression.RangePartitionPruner;
import org.tikv.common.meta.TiPartitionDef;
import org.tikv.common.meta.TiPartitionInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.parser.TiParser;

public class PartitionPruner {
    public static List<Expression> extractLogicalOrComparisonExpr(List<Expression> filters) {
        ArrayList<Expression> filteredFilters = new ArrayList<Expression>();
        for (Expression expr : filters) {
            if (!(expr instanceof LogicalBinaryExpression) && !(expr instanceof ComparisonBinaryExpression)) continue;
            filteredFilters.add(expr);
        }
        return filteredFilters;
    }

    public static List<TiPartitionDef> prune(TiTableInfo tableInfo, List<Expression> filters) {
        TiPartitionInfo.PartitionType type = tableInfo.getPartitionInfo().getType();
        if (!tableInfo.isPartitionEnabled()) {
            return tableInfo.getPartitionInfo().getDefs();
        }
        boolean isRangeCol = Objects.requireNonNull(tableInfo.getPartitionInfo().getColumns()).size() > 0;
        switch (type) {
            case RangePartition: {
                if (!isRangeCol) {
                    if (tableInfo.getPartitionInfo().getColumns().size() > 1) {
                        return tableInfo.getPartitionInfo().getDefs();
                    }
                    RangePartitionPruner prunner = new RangePartitionPruner(tableInfo);
                    return prunner.prune(filters);
                }
                RangeColumnPartitionPruner pruner = new RangeColumnPartitionPruner(tableInfo);
                return pruner.prune(filters);
            }
            case ListPartition: 
            case HashPartition: {
                return tableInfo.getPartitionInfo().getDefs();
            }
        }
        throw new UnsupportedOperationException("cannot prune under invalid partition table");
    }

    static void generateRangeExprs(TiPartitionInfo partInfo, List<Expression> partExprs, TiParser parser, String partExprStr, int lessThanIdx) {
        for (int i = 0; i < partInfo.getDefs().size(); ++i) {
            TiPartitionDef pDef = partInfo.getDefs().get(i);
            String current = pDef.getLessThan().get(lessThanIdx);
            String leftHand = current.equals("MAXVALUE") ? "true" : String.format("%s < %s", partExprStr, current);
            if (i == 0) {
                partExprs.add(parser.parseExpression(leftHand));
                continue;
            }
            String previous = partInfo.getDefs().get(i - 1).getLessThan().get(lessThanIdx);
            String and = String.format("%s and %s", partExprStr + ">=" + previous, leftHand);
            partExprs.add(parser.parseExpression(and));
        }
    }
}

