/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import org.apache.flink.cdc.connectors.tidb.table.TiKVAppendMetadataCollector;
import org.apache.flink.cdc.connectors.tidb.table.TiKVDeserializationRuntimeConverter;
import org.apache.flink.cdc.connectors.tidb.table.TiKVMetadataConverter;
import org.apache.flink.cdc.debezium.utils.TemporalConversions;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.tikv.common.TiConfiguration;
import org.tikv.common.TiSession;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.types.DataType;

public class RowDataTiKVEventDeserializationSchemaBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean hasMetadata;
    protected TiTableInfo tableInfo;
    private final TiConfiguration tiConf;
    private final String database;
    private final String tableName;
    private final TiKVAppendMetadataCollector appendMetadataCollector;
    protected final TiKVDeserializationRuntimeConverter physicalConverter;

    public RowDataTiKVEventDeserializationSchemaBase(TiConfiguration tiConf, String database, String tableName, TiKVMetadataConverter[] metadataConverters, RowType physicalDataType) {
        this.tiConf = (TiConfiguration)Preconditions.checkNotNull((Object)tiConf);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.hasMetadata = ((TiKVMetadataConverter[])Preconditions.checkNotNull((Object)metadataConverters)).length > 0;
        this.appendMetadataCollector = new TiKVAppendMetadataCollector(metadataConverters);
        this.physicalConverter = RowDataTiKVEventDeserializationSchemaBase.createConverter((LogicalType)Preconditions.checkNotNull((Object)physicalDataType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TiTableInfo fetchTableInfo() {
        try (TiSession session = TiSession.create(this.tiConf);){
            TiTableInfo tiTableInfo = session.getCatalog().getTable(this.database, this.tableName);
            return tiTableInfo;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void emit(TiKVMetadataConverter.TiKVRowValue inRecord, RowData physicalRow, Collector<RowData> collector) {
        if (!this.hasMetadata) {
            collector.collect((Object)physicalRow);
            return;
        }
        this.appendMetadataCollector.row = inRecord;
        this.appendMetadataCollector.outputCollector = collector;
        this.appendMetadataCollector.collect(physicalRow);
    }

    protected static TiKVDeserializationRuntimeConverter createConverter(LogicalType type) {
        return RowDataTiKVEventDeserializationSchemaBase.wrapIntoNullableConverter(RowDataTiKVEventDeserializationSchemaBase.createNotNullConverter(type));
    }

    public static TiKVDeserializationRuntimeConverter createNotNullConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return new TiKVDeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                        return null;
                    }
                };
            }
            case BOOLEAN: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToBoolean();
            }
            case TINYINT: {
                return new TiKVDeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                        return Byte.parseByte(object.toString());
                    }
                };
            }
            case SMALLINT: {
                return new TiKVDeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                        return Short.parseShort(object.toString());
                    }
                };
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToInt();
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToLong();
            }
            case DATE: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToDate();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToTime();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToTimestamp();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToLocalTimeZoneTimestamp();
            }
            case FLOAT: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToFloat();
            }
            case DOUBLE: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToDouble();
            }
            case CHAR: 
            case VARCHAR: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToString();
            }
            case BINARY: 
            case VARBINARY: {
                return RowDataTiKVEventDeserializationSchemaBase.convertToBinary();
            }
            case DECIMAL: {
                return RowDataTiKVEventDeserializationSchemaBase.createDecimalConverter((DecimalType)type);
            }
            case ROW: {
                return RowDataTiKVEventDeserializationSchemaBase.createRowConverter((RowType)type);
            }
            case ARRAY: {
                return new TiKVDeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object object, TiTableInfo tableInfo, DataType dataType) throws Exception {
                        String[] strArray = ((String)object).split(",");
                        Object[] stringDataArray = new StringData[strArray.length];
                        for (int i = 0; i < strArray.length; ++i) {
                            stringDataArray[i] = StringData.fromString((String)strArray[i]);
                        }
                        return new GenericArrayData(stringDataArray);
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static TiKVDeserializationRuntimeConverter convertToBoolean() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof Boolean) {
                    return object;
                }
                if (object instanceof Long) {
                    return (Long)object == 1L;
                }
                if (object instanceof Byte) {
                    return (Byte)object == 1;
                }
                if (object instanceof Short) {
                    return (Short)object == 1;
                }
                return Boolean.parseBoolean(object.toString());
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToInt() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof Integer) {
                    return object;
                }
                if (object instanceof Long) {
                    return dataType.isUnsigned() ? Integer.valueOf(Short.toUnsignedInt(((Long)object).shortValue())).intValue() : ((Long)object).intValue();
                }
                return Integer.parseInt(object.toString());
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToLong() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof Integer) {
                    return ((Integer)object).longValue();
                }
                if (object instanceof Long) {
                    return object;
                }
                return Long.parseLong(object.toString());
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToDouble() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof Float) {
                    return ((Float)object).doubleValue();
                }
                if (object instanceof Double) {
                    return object;
                }
                return Double.parseDouble(object.toString());
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToFloat() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof Float) {
                    return object;
                }
                if (object instanceof Double) {
                    return Float.valueOf(((Double)object).floatValue());
                }
                return Float.valueOf(Float.parseFloat(object.toString()));
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToDate() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                return (int)TemporalConversions.toLocalDate(object).toEpochDay();
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToTime() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof Long) {
                    return (int)((Long)object / 1000000L);
                }
                return TemporalConversions.toLocalTime(object).toSecondOfDay() * 1000;
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToTimestamp() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                switch (dataType.getType()) {
                    case TypeTimestamp: {
                        if (!(object instanceof Timestamp)) break;
                        return TimestampData.fromInstant((Instant)((Timestamp)object).toInstant());
                    }
                    case TypeDatetime: {
                        if (!(object instanceof Timestamp)) break;
                        return TimestampData.fromLocalDateTime((LocalDateTime)((Timestamp)object).toLocalDateTime());
                    }
                    default: {
                        throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + object + "' of type " + object.getClass().getName());
                    }
                }
                return object;
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToLocalTimeZoneTimestamp() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof Timestamp) {
                    return TimestampData.fromInstant((Instant)((Timestamp)object).toInstant());
                }
                throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + object + "' of type " + object.getClass().getName());
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToString() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof byte[]) {
                    return StringData.fromBytes((byte[])((byte[])object));
                }
                return StringData.fromString((String)object.toString());
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter convertToBinary() {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                if (object instanceof byte[]) {
                    return object;
                }
                if (object instanceof String) {
                    return ((String)object).getBytes();
                }
                if (object instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)object;
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                throw new UnsupportedOperationException("Unsupported BYTES value type: " + object.getClass().getSimpleName());
            }
        };
    }

    public static Object dealUnsignedColumnValue(DataType dataType, Object object) {
        switch (dataType.getType()) {
            case TypeTiny: {
                return (short)Byte.toUnsignedInt(((Long)object).byteValue());
            }
            case TypeShort: {
                return Short.toUnsignedInt(((Long)object).shortValue());
            }
            case TypeInt24: {
                return ((Long)object).intValue() & 0xFFFFFF;
            }
            case TypeLong: {
                return Integer.toUnsignedLong(((Long)object).intValue());
            }
            case TypeLonglong: {
                return new BigDecimal(Long.toUnsignedString((Long)object));
            }
        }
        return object;
    }

    private static TiKVDeserializationRuntimeConverter createDecimalConverter(DecimalType decimalType) {
        final int precision = decimalType.getPrecision();
        final int scale = decimalType.getScale();
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) {
                BigDecimal bigDecimal;
                if (object instanceof String) {
                    bigDecimal = new BigDecimal((String)object);
                } else if (object instanceof Long) {
                    bigDecimal = new BigDecimal((String)object);
                } else if (object instanceof Double) {
                    bigDecimal = BigDecimal.valueOf((Double)object);
                } else if (object instanceof BigDecimal) {
                    bigDecimal = (BigDecimal)object;
                } else {
                    throw new IllegalArgumentException("Unable to convert to decimal from unexpected value '" + object + "' of type " + object.getClass());
                }
                return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)precision, (int)scale);
            }
        };
    }

    private static TiKVDeserializationRuntimeConverter createRowConverter(RowType rowType) {
        final TiKVDeserializationRuntimeConverter[] fieldConverters = (TiKVDeserializationRuntimeConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(logicType -> RowDataTiKVEventDeserializationSchemaBase.createConverter(logicType)).toArray(TiKVDeserializationRuntimeConverter[]::new);
        final String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo tableInfo, DataType dataType) throws Exception {
                int arity = fieldNames.length;
                GenericRowData row = new GenericRowData(arity);
                for (int i = 0; i < arity; ++i) {
                    String fieldName = fieldNames[i];
                    TiColumnInfo columnInfo = tableInfo.getColumn(fieldName);
                    if (columnInfo == null) {
                        row.setField(i, null);
                        continue;
                    }
                    int offset = columnInfo.getOffset();
                    DataType type = columnInfo.getType();
                    Object convertedField = RowDataTiKVEventDeserializationSchemaBase.convertField(fieldConverters[i], tableInfo, type, ((Object[])object)[offset]);
                    row.setField(i, convertedField);
                }
                return row;
            }
        };
    }

    private static Object convertField(TiKVDeserializationRuntimeConverter fieldConverter, TiTableInfo tableInfo, DataType dataType, Object fieldValue) throws Exception {
        if (fieldValue == null) {
            return null;
        }
        if (dataType.isUnsigned()) {
            fieldValue = RowDataTiKVEventDeserializationSchemaBase.dealUnsignedColumnValue(dataType, fieldValue);
        }
        return fieldConverter.convert(fieldValue, tableInfo, dataType);
    }

    private static TiKVDeserializationRuntimeConverter wrapIntoNullableConverter(final TiKVDeserializationRuntimeConverter converter) {
        return new TiKVDeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object object, TiTableInfo schema, DataType dataType) throws Exception {
                if (object == null) {
                    return null;
                }
                return converter.convert(object, schema, dataType);
            }
        };
    }
}

